/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class OzoneSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneSecurityUtil.class);
    private static final Set<String> INVALID_IPS = new HashSet<String>(Arrays.asList("0.0.0.0", "127.0.0.1"));

    private OzoneSecurityUtil() {
    }

    public static boolean isSecurityEnabled(ConfigurationSource conf) {
        SecurityConfig.initSecurityProvider(conf);
        return conf.getBoolean("ozone.security.enabled", false);
    }

    public static boolean isHttpSecurityEnabled(ConfigurationSource conf) {
        return OzoneSecurityUtil.isSecurityEnabled(conf) && conf.getBoolean("ozone.security.http.kerberos.enabled", false);
    }

    public static boolean checkIfFileExist(Path path, String fileName) {
        File dir = path.toFile();
        return dir.exists() && new File(dir, fileName).exists();
    }

    public static List<InetAddress> getValidInetsForCurrentHost() throws IOException {
        ArrayList<InetAddress> hostIps = new ArrayList<InetAddress>();
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        Enumeration<NetworkInterface> enumNI = NetworkInterface.getNetworkInterfaces();
        if (enumNI == null) {
            throw new IOException("Unable to get network interfaces.");
        }
        while (enumNI.hasMoreElements()) {
            NetworkInterface ifc = enumNI.nextElement();
            if (!ifc.isUp()) continue;
            Enumeration<InetAddress> enumAdds = ifc.getInetAddresses();
            while (enumAdds.hasMoreElements()) {
                InetAddress addr = enumAdds.nextElement();
                String hostAddress = addr.getHostAddress();
                if (!INVALID_IPS.contains(hostAddress) && ipValidator.isValid(hostAddress) && !OzoneSecurityUtil.isScopedOrMaskingIPv6Address(addr)) {
                    LOG.info("Adding ip:{},host:{}", (Object)hostAddress, (Object)addr.getHostName());
                    hostIps.add(addr);
                    continue;
                }
                LOG.info("ip:{} not returned.", (Object)hostAddress);
            }
        }
        return hostIps;
    }

    public static boolean isScopedOrMaskingIPv6Address(InetAddress addr) {
        if (addr instanceof Inet6Address) {
            String hostAddress = addr.getHostAddress();
            return hostAddress.contains("/") || hostAddress.contains("%");
        }
        return false;
    }

    public static List<X509Certificate> convertToX509(List<String> pemEncodedCerts) throws IOException {
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>(pemEncodedCerts.size());
        for (String cert : pemEncodedCerts) {
            x509Certificates.add(CertificateCodec.readX509Certificate(cert));
        }
        return x509Certificates;
    }
}

