/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.hsqldb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.hsqldb.HSQLDBRoutineDefinition;
import org.jooq.meta.hsqldb.HSQLDBTableDefinition;
import org.jooq.meta.hsqldb.information_schema.Tables;
import org.jooq.meta.hsqldb.information_schema.tables.CheckConstraints;
import org.jooq.meta.hsqldb.information_schema.tables.TableConstraints;
import org.jooq.tools.JooqLogger;

public class HSQLDBDatabase
extends AbstractDatabase {
    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.HSQLDB);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Map indexes = this.create().select(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM, Tables.SYSTEM_INDEXINFO.TABLE_NAME, Tables.SYSTEM_INDEXINFO.INDEX_NAME, Tables.SYSTEM_INDEXINFO.NON_UNIQUE, Tables.SYSTEM_INDEXINFO.COLUMN_NAME, Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION, Tables.SYSTEM_INDEXINFO.ASC_OR_DESC).from((TableLike)Tables.SYSTEM_INDEXINFO).where(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM.in(this.getInputSchemata())).orderBy(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM, Tables.SYSTEM_INDEXINFO.TABLE_NAME, Tables.SYSTEM_INDEXINFO.INDEX_NAME, Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION).fetchGroups(new Field[]{Tables.SYSTEM_INDEXINFO.TABLE_SCHEM, Tables.SYSTEM_INDEXINFO.TABLE_NAME, Tables.SYSTEM_INDEXINFO.INDEX_NAME, Tables.SYSTEM_INDEXINFO.NON_UNIQUE}, new Field[]{Tables.SYSTEM_INDEXINFO.COLUMN_NAME, Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION, Tables.SYSTEM_INDEXINFO.ASC_OR_DESC});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result cols = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(Tables.SYSTEM_INDEXINFO.INDEX_NAME);
            String tableName = (String)index.get(Tables.SYSTEM_INDEXINFO.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(Tables.SYSTEM_INDEXINFO.NON_UNIQUE, Boolean.TYPE) == false;
            for (Record column : cols) {
                if (table.getColumn((String)column.get(Tables.SYSTEM_INDEXINFO.COLUMN_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : cols) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Tables.SYSTEM_INDEXINFO.COLUMN_NAME)), "D".equals(column.get(Tables.SYSTEM_INDEXINFO.ASC_OR_DESC)) ? SortOrder.DESC : SortOrder.ASC, (Integer)column.get(Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME).from((TableLike)Tables.TABLE_CONSTRAINTS.join((TableLike)Tables.KEY_COLUMN_USAGE).on(Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA)).and(Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME))).where(Tables.TABLE_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType)).and(Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy((OrderField)Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result result = this.create().select(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME, Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA, Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME).from((TableLike)Tables.REFERENTIAL_CONSTRAINTS).join((TableLike)Tables.KEY_COLUMN_USAGE).on(Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA.equal(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA)).and(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.equal(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME)).where(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy((OrderField)Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String foreignKeyTable = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String foreignKeyColumn = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            String uniqueKey = (String)record.get(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        TableConstraints tc = Tables.TABLE_CONSTRAINTS.as("tc");
        CheckConstraints cc = Tables.CHECK_CONSTRAINTS.as("cc");
        Field constraintName = DSL.field((Name)DSL.name((String)cc.CONSTRAINT_NAME.getName()), String.class);
        for (Record record : this.create().select(tc.TABLE_SCHEMA, tc.TABLE_NAME, (SelectField)constraintName, cc.CHECK_CLAUSE).from((TableLike)tc).join((TableLike)cc).using(new Field[]{tc.CONSTRAINT_CATALOG, tc.CONSTRAINT_SCHEMA, tc.CONSTRAINT_NAME}).where(tc.TABLE_SCHEMA.in(this.getInputSchemata())).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(tc.TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.get(tc.TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(constraintName), (String)record.get(cc.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Tables.SCHEMATA.SCHEMA_NAME).from((TableLike)Tables.SCHEMATA).fetch(Tables.SCHEMATA.SCHEMA_NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, Tables.SEQUENCES.DATA_TYPE).from((TableLike)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.get(Tables.SEQUENCES.DATA_TYPE));
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).from((TableLike)Tables.TABLES).where(Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.get(Tables.TABLES.TABLE_NAME);
            String comment = "";
            result.add(new HSQLDBTableDefinition(schema, name, comment));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, (SelectField)DSL.nvl(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER, Tables.ROUTINES.DATA_TYPE).as("datatype"), Tables.ROUTINES.NUMERIC_PRECISION, Tables.ROUTINES.NUMERIC_SCALE, (SelectField)DSL.field((Condition)Tables.ROUTINES.ROUTINE_DEFINITION.likeRegex(".*(?i:(\\w+\\s+)+aggregate\\s+function).*")).as("aggregate")).from((TableLike)Tables.ROUTINES).leftOuterJoin((TableLike)Tables.ELEMENT_TYPES).on(Tables.ROUTINES.ROUTINE_SCHEMA.equal(Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(Tables.ROUTINES.ROUTINE_NAME.equal(Tables.ELEMENT_TYPES.OBJECT_NAME)).and(Tables.ROUTINES.DTD_IDENTIFIER.equal(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(Tables.ROUTINES.ROUTINE_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME).fetch()) {
            String datatype = (String)record.get("datatype", String.class);
            if (datatype != null && datatype.toUpperCase().startsWith("ROW")) {
                JooqLogger.getLogger(this.getClass()).info((Object)("A row : " + datatype));
                datatype = "ROW";
            }
            result.add(new HSQLDBRoutineDefinition(this.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)), (String)record.get(Tables.ROUTINES.ROUTINE_NAME), (String)record.get(Tables.ROUTINES.SPECIFIC_NAME), datatype, (Number)record.get(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(Tables.ROUTINES.NUMERIC_SCALE), (Boolean)record.get("aggregate", Boolean.TYPE)));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

