/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMSecurityProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;

public class SCMSecurityProtocolClientSideTranslatorPB
implements SCMSecurityProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final SCMSecurityProtocolPB rpcProxy;

    public SCMSecurityProtocolClientSideTranslatorPB(SCMSecurityProtocolFailoverProxyProvider failoverProxyProvider) {
        Objects.requireNonNull(failoverProxyProvider, "failoverProxyProvider == null");
        this.rpcProxy = (SCMSecurityProtocolPB)RetryProxy.create(SCMSecurityProtocolPB.class, (FailoverProxyProvider)failoverProxyProvider, (RetryPolicy)failoverProxyProvider.getRetryPolicy());
    }

    private SCMSecurityProtocolProtos.SCMSecurityResponse submitRequest(SCMSecurityProtocolProtos.Type type, Consumer<SCMSecurityProtocolProtos.SCMSecurityRequest.Builder> builderConsumer) throws IOException {
        SCMSecurityProtocolProtos.SCMSecurityResponse response;
        try {
            SCMSecurityProtocolProtos.SCMSecurityRequest.Builder builder = SCMSecurityProtocolProtos.SCMSecurityRequest.newBuilder().setCmdType(type).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            SCMSecurityProtocolProtos.SCMSecurityRequest wrapper = builder.build();
            response = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
            this.handleError(response);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    private SCMSecurityProtocolProtos.SCMSecurityResponse handleError(SCMSecurityProtocolProtos.SCMSecurityResponse resp) throws SCMSecurityException {
        if (resp.getStatus() != SCMSecurityProtocolProtos.Status.OK) {
            throw new SCMSecurityException(resp.getMessage(), SCMSecurityException.ErrorCode.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public String getDataNodeCertificate(HddsProtos.DatanodeDetailsProto dataNodeDetails, String certSignReq) throws IOException {
        return this.getDataNodeCertificateChain(dataNodeDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getOMCertificate(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        return this.getOMCertChain(omDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getCertificate(HddsProtos.NodeDetailsProto nodeDetails, String certSignReq) throws IOException {
        return this.getCertificateChain(nodeDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getSCMCertificate(HddsProtos.ScmNodeDetailsProto scmNodeDetails, String certSignReq) throws IOException {
        return this.getSCMCertChain(scmNodeDetails, certSignReq, false).getX509Certificate();
    }

    @Override
    public String getSCMCertificate(HddsProtos.ScmNodeDetailsProto scmNodeDetails, String certSignReq, boolean renew) throws IOException {
        return this.getSCMCertChain(scmNodeDetails, certSignReq, renew).getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getSCMCertChain(HddsProtos.ScmNodeDetailsProto scmNodeDetails, String certSignReq, boolean isRenew) throws IOException {
        SCMSecurityProtocolProtos.SCMGetSCMCertRequestProto request = SCMSecurityProtocolProtos.SCMGetSCMCertRequestProto.newBuilder().setCSR(certSignReq).setScmDetails(scmNodeDetails).setRenew(isRenew).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetSCMCertificate, builder -> builder.setGetSCMCertificateRequest(request)).getGetCertResponseProto();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertChain(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetOMCertRequestProto request = SCMSecurityProtocolProtos.SCMGetOMCertRequestProto.newBuilder().setCSR(certSignReq).setOmDetails(omDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetOMCertificate, builder -> builder.setGetOMCertRequest(request)).getGetCertResponseProto();
    }

    @Override
    public String getCertificate(String certSerialId) throws IOException {
        SCMSecurityProtocolProtos.SCMGetCertificateRequestProto request = SCMSecurityProtocolProtos.SCMGetCertificateRequestProto.newBuilder().setCertSerialId(certSerialId).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCertificate, builder -> builder.setGetCertificateRequest(request)).getGetCertResponseProto().getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificateChain(HddsProtos.DatanodeDetailsProto dnDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto request = SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto.newBuilder().setCSR(certSignReq).setDatanodeDetails(dnDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetDataNodeCertificate, builder -> builder.setGetDataNodeCertRequest(request)).getGetCertResponseProto();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCertificateChain(HddsProtos.NodeDetailsProto nodeDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetCertRequestProto request = SCMSecurityProtocolProtos.SCMGetCertRequestProto.newBuilder().setCSR(certSignReq).setNodeDetails(nodeDetails).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCert, builder -> builder.setGetCertRequest(request)).getGetCertResponseProto();
    }

    @Override
    public String getCACertificate() throws IOException {
        return this.getCACert().getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCACert() throws IOException {
        SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetCACertificate, builder -> builder.setGetCACertificateRequest(protoIns)).getGetCertResponseProto();
    }

    @Override
    public List<String> listCertificate(HddsProtos.NodeType role, long startSerialId, int count) throws IOException {
        SCMSecurityProtocolProtos.SCMListCertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMListCertificateRequestProto.newBuilder().setRole(role).setStartCertId(startSerialId).setCount(count).build();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.ListCertificate, builder -> builder.setListCertificateRequest(protoIns)).getListCertificateResponseProto().getCertificatesList();
    }

    @Override
    public String getRootCACertificate() throws IOException {
        SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetRootCACertificate, builder -> builder.setGetCACertificateRequest(protoIns)).getGetCertResponseProto().getX509RootCACertificate();
    }

    @Override
    public List<String> listCACertificate() throws IOException {
        SCMSecurityProtocolProtos.SCMListCACertificateRequestProto proto = SCMSecurityProtocolProtos.SCMListCACertificateRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.ListCACertificate, builder -> builder.setListCACertificateRequestProto(proto)).getListCertificateResponseProto().getCertificatesList();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public List<String> getAllRootCaCertificates() throws IOException {
        SCMSecurityProtocolProtos.SCMGetAllRootCaCertificatesRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetAllRootCaCertificatesRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.GetAllRootCaCertificates, builder -> builder.setGetAllRootCaCertificatesRequestProto(protoIns)).getAllRootCaCertificatesResponseProto().getAllX509RootCaCertificatesList();
    }

    @Override
    public List<String> removeExpiredCertificates() throws IOException {
        SCMSecurityProtocolProtos.SCMRemoveExpiredCertificatesRequestProto protoIns = SCMSecurityProtocolProtos.SCMRemoveExpiredCertificatesRequestProto.getDefaultInstance();
        return this.submitRequest(SCMSecurityProtocolProtos.Type.RemoveExpiredCertificates, builder -> builder.setRemoveExpiredCertificatesRequestProto(protoIns)).getRemoveExpiredCertificatesResponseProto().getRemovedExpiredCertificatesList();
    }
}

