/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApprover
implements CertificateApprover {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApprover.class);
    private final PKIProfile profile;
    private final SecurityConfig securityConfig;

    public DefaultApprover(PKIProfile pkiProfile, SecurityConfig config) {
        this.profile = Objects.requireNonNull(pkiProfile);
        this.securityConfig = Objects.requireNonNull(config);
    }

    @Override
    public X509Certificate sign(SecurityConfig config, PrivateKey caPrivate, X509Certificate caCertificate, Date validFrom, Date validTill, PKCS10CertificationRequest certificationRequest, String scmId, String clusterId, String certSerialId) throws IOException, CertificateException {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(config.getSignatureAlgo());
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter asymmetricKP = PrivateKeyFactory.createKey((byte[])caPrivate.getEncoded());
        SubjectPublicKeyInfo keyInfo = certificationRequest.getSubjectPublicKeyInfo();
        X500Name x500Name = certificationRequest.getSubject();
        String csrScmId = x500Name.getRDNs(BCStyle.OU)[0].getFirst().getValue().toASN1Primitive().toString();
        String csrClusterId = x500Name.getRDNs(BCStyle.O)[0].getFirst().getValue().toASN1Primitive().toString();
        String cn = x500Name.getRDNs(BCStyle.CN)[0].getFirst().getValue().toASN1Primitive().toString();
        if (!clusterId.equals(csrClusterId)) {
            if (csrScmId.equalsIgnoreCase("null") && csrClusterId.equalsIgnoreCase("null")) {
                csrClusterId = clusterId;
                csrScmId = scmId;
            } else {
                throw new SCMSecurityException("ScmId and ClusterId in CSR subject are incorrect.");
            }
        }
        x500Name = CertificateSignRequest.getDistinguishedNameWithSN((String)cn, (String)csrScmId, (String)csrClusterId, (String)certSerialId);
        RSAKeyParameters rsa = (RSAKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)keyInfo);
        if (rsa.getModulus().bitLength() < config.getSize()) {
            throw new SCMSecurityException("Key size is too small in certificate signing request");
        }
        X509v3CertificateBuilder certificateGenerator = new X509v3CertificateBuilder(new X509CertificateHolder(caCertificate.getEncoded()).getSubject(), new BigInteger(certSerialId), validFrom, validTill, x500Name, keyInfo);
        Extensions exts = CertificateSignRequest.getPkcs9Extensions((PKCS10CertificationRequest)certificationRequest);
        LOG.info("Extensions in CSR: {}", (Object)Arrays.stream(exts.getExtensionOIDs()).map(ASN1ObjectIdentifier::getId).collect(Collectors.joining(", ")));
        LOG.info("Extensions to add to the certificate if they present in CSR: {}", (Object)Arrays.stream(this.profile.getSupportedExtensions()).map(oid -> oid == null ? "null" : oid.getId()).collect(Collectors.joining(", ")));
        for (ASN1ObjectIdentifier extId : this.profile.getSupportedExtensions()) {
            Extension ext = exts.getExtension(extId);
            if (ext == null) continue;
            certificateGenerator.addExtension(ext);
        }
        try {
            ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(asymmetricKP);
            return new JcaX509CertificateConverter().getCertificate(certificateGenerator.build(sigGen));
        }
        catch (OperatorCreationException oce) {
            throw new CertificateException(oce);
        }
    }

    private Attribute[] getAttributes(PKCS10CertificationRequest request) {
        Objects.requireNonNull(request);
        return request.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
    }

    private List<Extensions> getExtensionsList(Attribute attribute) {
        Objects.requireNonNull(attribute);
        ArrayList<Extensions> extensionsList = new ArrayList<Extensions>();
        for (ASN1Encodable value : attribute.getAttributeValues()) {
            if (value == null) continue;
            Extensions extensions = Extensions.getInstance((Object)value);
            extensionsList.add(extensions);
        }
        return extensionsList;
    }

    private List<Extension> getIndividualExtension(Extensions extensions) {
        Objects.requireNonNull(extensions);
        ArrayList<Extension> extenList = new ArrayList<Extension>();
        for (ASN1ObjectIdentifier id : extensions.getExtensionOIDs()) {
            Extension ext;
            if (id == null || (ext = extensions.getExtension(id)) == null) continue;
            extenList.add(ext);
        }
        return extenList;
    }

    @VisibleForTesting
    boolean verfiyExtensions(PKCS10CertificationRequest request) {
        Objects.requireNonNull(request);
        for (Attribute attr : this.getAttributes(request)) {
            for (Extensions extensionsList : this.getExtensionsList(attr)) {
                for (Extension extension : this.getIndividualExtension(extensionsList)) {
                    if (this.profile.validateExtension(extension)) continue;
                    LOG.error("Failed to verify extension. {}", (Object)extension.getExtnId().getId());
                    return false;
                }
            }
        }
        return true;
    }

    @VisibleForTesting
    boolean verifyPkcs10Request(PKCS10CertificationRequest pkcs10Request) throws OperatorCreationException, PKCSException {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(this.securityConfig.getProvider()).build(pkcs10Request.getSubjectPublicKeyInfo());
        return pkcs10Request.isSignatureValid(verifierProvider);
    }

    @Override
    public CompletableFuture<Void> inspectCSR(PKCS10CertificationRequest csr) {
        CompletableFuture<Void> response = new CompletableFuture<Void>();
        try {
            if (!this.verifyPkcs10Request(csr)) {
                LOG.error("Failed to verify the signature in CSR.");
                response.completeExceptionally(new SCMSecurityException("Failed to verify the CSR."));
            }
            for (RDN rdn : csr.getSubject().getRDNs()) {
                if (this.profile.validateRDN(rdn)) continue;
                LOG.error("Failed in verifying RDNs");
                response.completeExceptionally(new SCMSecurityException("Failed to verify the RDNs. Please check the subject name."));
            }
            if (!this.verfiyExtensions(csr)) {
                LOG.error("failed in verification of extensions.");
                response.completeExceptionally(new SCMSecurityException("Failed to verify extensions."));
            }
        }
        catch (OperatorCreationException | PKCSException e) {
            LOG.error("Approval Failure.", e);
            response.completeExceptionally(new SCMSecurityException(e));
        }
        return response;
    }
}

