/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.nio.file.Path;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.DBConfigFromFile;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.RocksDBException;

public class TableConfig
implements AutoCloseable {
    private final String name;
    private final ManagedColumnFamilyOptions columnFamilyOptions;

    public static String toName(byte[] bytes) {
        return StringUtils.bytes2String((byte[])bytes);
    }

    public TableConfig(String name, ManagedColumnFamilyOptions columnFamilyOptions) {
        this.name = name;
        this.columnFamilyOptions = columnFamilyOptions;
    }

    static TableConfig newTableConfig(Path dbPath, String name) {
        ManagedColumnFamilyOptions cfOptions = null;
        try {
            cfOptions = DBConfigFromFile.readCFOptionsFromFile(dbPath, name);
        }
        catch (RocksDBException rocksDBException) {
            // empty catch block
        }
        if (cfOptions == null) {
            cfOptions = DBStoreBuilder.HDDS_DEFAULT_DB_PROFILE.getColumnFamilyOptions();
        }
        return new TableConfig(name, cfOptions);
    }

    public String getName() {
        return this.name;
    }

    public ColumnFamilyDescriptor getDescriptor() {
        return new ColumnFamilyDescriptor(StringUtils.string2Bytes((String)this.name), (ColumnFamilyOptions)new ManagedColumnFamilyOptions((ColumnFamilyOptions)this.columnFamilyOptions));
    }

    public ManagedColumnFamilyOptions getColumnFamilyOptions() {
        return this.columnFamilyOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConfig that = (TableConfig)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void close() {
        if (!this.columnFamilyOptions.isReused()) {
            this.columnFamilyOptions.close();
        }
    }
}

