/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeleteOptions may be provided when deleting an API object.")
public class V1DeleteOptions {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DRY_RUN = "dryRun";
    @SerializedName(value="dryRun")
    private List<String> dryRun = null;
    public static final String SERIALIZED_NAME_GRACE_PERIOD_SECONDS = "gracePeriodSeconds";
    @SerializedName(value="gracePeriodSeconds")
    private Long gracePeriodSeconds;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_ORPHAN_DEPENDENTS = "orphanDependents";
    @SerializedName(value="orphanDependents")
    private Boolean orphanDependents;
    public static final String SERIALIZED_NAME_PRECONDITIONS = "preconditions";
    @SerializedName(value="preconditions")
    private V1Preconditions preconditions;
    public static final String SERIALIZED_NAME_PROPAGATION_POLICY = "propagationPolicy";
    @SerializedName(value="propagationPolicy")
    private String propagationPolicy;

    public V1DeleteOptions apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1DeleteOptions dryRun(List<String> dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public V1DeleteOptions addDryRunItem(String dryRunItem) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(dryRunItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed")
    public List<String> getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(List<String> dryRun) {
        this.dryRun = dryRun;
    }

    public V1DeleteOptions gracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.")
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public void setGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
    }

    public V1DeleteOptions kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1DeleteOptions orphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.")
    public Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    public void setOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
    }

    public V1DeleteOptions preconditions(V1Preconditions preconditions) {
        this.preconditions = preconditions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Preconditions getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(V1Preconditions preconditions) {
        this.preconditions = preconditions;
    }

    public V1DeleteOptions propagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.")
    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public void setPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeleteOptions v1DeleteOptions = (V1DeleteOptions)o;
        return Objects.equals(this.apiVersion, v1DeleteOptions.apiVersion) && Objects.equals(this.dryRun, v1DeleteOptions.dryRun) && Objects.equals(this.gracePeriodSeconds, v1DeleteOptions.gracePeriodSeconds) && Objects.equals(this.kind, v1DeleteOptions.kind) && Objects.equals(this.orphanDependents, v1DeleteOptions.orphanDependents) && Objects.equals(this.preconditions, v1DeleteOptions.preconditions) && Objects.equals(this.propagationPolicy, v1DeleteOptions.propagationPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1DeleteOptions {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    gracePeriodSeconds: ").append(this.toIndentedString(this.gracePeriodSeconds)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    orphanDependents: ").append(this.toIndentedString(this.orphanDependents)).append("\n");
        sb.append("    preconditions: ").append(this.toIndentedString(this.preconditions)).append("\n");
        sb.append("    propagationPolicy: ").append(this.toIndentedString(this.propagationPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

