/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.LongArrayBlock;

public class LongArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "LONG_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeLong(block.getLong(position, 0));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull != null && valueIsNull[position]) continue;
            values[position] = sliceInput.readLong();
        }
        return new LongArrayBlock(0, positionCount, valueIsNull, values);
    }
}

