/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStatsNodes
implements ToXContentFragment {
    private final Counts counts;
    private final Set<Version> versions = new HashSet<Version>();
    private final OsStats os;
    private final ProcessStats process;
    private final JvmStats jvm;
    private final FsInfo.Path fs;
    private final Set<PluginDescriptor> plugins = new HashSet<PluginDescriptor>();
    private final NetworkTypes networkTypes;
    private final DiscoveryTypes discoveryTypes;
    private final PackagingTypes packagingTypes;
    private final IngestStats ingestStats;

    ClusterStatsNodes(List<ClusterStatsNodeResponse> nodeResponses) {
        ClusterFsStatsDeduplicator deduplicator = new ClusterFsStatsDeduplicator(nodeResponses.size());
        ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(nodeResponses.size());
        ArrayList<NodeStats> nodeStats = new ArrayList<NodeStats>(nodeResponses.size());
        for (ClusterStatsNodeResponse nodeResponse : nodeResponses) {
            nodeInfos.add(nodeResponse.nodeInfo());
            nodeStats.add(nodeResponse.nodeStats());
            this.versions.add(nodeResponse.nodeInfo().getVersion());
            this.plugins.addAll(nodeResponse.nodeInfo().getInfo(PluginsAndModules.class).getPluginInfos());
            TransportAddress publishAddress = nodeResponse.nodeInfo().getInfo(TransportInfo.class).address().publishAddress();
            InetAddress inetAddress = publishAddress.address().getAddress();
            deduplicator.add(inetAddress, nodeResponse.nodeStats().getFs());
        }
        this.fs = deduplicator.getTotal();
        this.counts = new Counts(nodeInfos);
        this.os = new OsStats(nodeInfos, nodeStats);
        this.process = new ProcessStats(nodeStats);
        this.jvm = new JvmStats(nodeInfos, nodeStats);
        this.networkTypes = new NetworkTypes(nodeInfos);
        this.discoveryTypes = new DiscoveryTypes(nodeInfos);
        this.packagingTypes = new PackagingTypes(nodeInfos);
        this.ingestStats = new IngestStats(nodeStats);
    }

    public Counts getCounts() {
        return this.counts;
    }

    public Set<Version> getVersions() {
        return this.versions;
    }

    public OsStats getOs() {
        return this.os;
    }

    public ProcessStats getProcess() {
        return this.process;
    }

    public JvmStats getJvm() {
        return this.jvm;
    }

    public FsInfo.Path getFs() {
        return this.fs;
    }

    public Set<PluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("count");
        this.counts.toXContent(builder, params);
        builder.endObject();
        builder.startArray("versions");
        for (Version v : this.versions) {
            builder.value(v.toString());
        }
        builder.endArray();
        builder.startObject("os");
        this.os.toXContent(builder, params);
        builder.endObject();
        builder.startObject("process");
        this.process.toXContent(builder, params);
        builder.endObject();
        builder.startObject("jvm");
        this.jvm.toXContent(builder, params);
        builder.endObject();
        builder.field("fs");
        this.fs.toXContent(builder, params);
        builder.startArray("plugins");
        for (PluginDescriptor pluginDescriptor : this.plugins) {
            pluginDescriptor.toXContent(builder, params);
        }
        builder.endArray();
        builder.startObject("network_types");
        this.networkTypes.toXContent(builder, params);
        builder.endObject();
        this.discoveryTypes.toXContent(builder, params);
        this.packagingTypes.toXContent(builder, params);
        this.ingestStats.toXContent(builder, params);
        return builder;
    }

    static class ClusterFsStatsDeduplicator {
        private final Set<DedupEntry> seenAddressesMountsPaths;
        private final FsInfo.Path total = new FsInfo.Path();

        ClusterFsStatsDeduplicator(int expectedSize) {
            this.seenAddressesMountsPaths = new HashSet<DedupEntry>(2 * expectedSize);
        }

        public void add(InetAddress inetAddress, FsInfo fsInfo) {
            if (fsInfo != null) {
                for (FsInfo.Path p : fsInfo) {
                    boolean seenAddressMountPath;
                    String mount = p.getMount();
                    String path = p.getPath();
                    boolean seenAddressMount = !this.seenAddressesMountsPaths.add(new DedupEntry(inetAddress, mount, null));
                    boolean bl = seenAddressMountPath = !this.seenAddressesMountsPaths.add(new DedupEntry(inetAddress, mount, path));
                    if (seenAddressMount && !seenAddressMountPath) continue;
                    this.total.add(p);
                }
            }
        }

        public FsInfo.Path getTotal() {
            FsInfo.Path result = new FsInfo.Path();
            result.add(this.total);
            return result;
        }

        private static class DedupEntry {
            private final InetAddress inetAddress;
            private final String mount;
            private final String path;

            DedupEntry(InetAddress inetAddress, String mount, String path) {
                this.inetAddress = inetAddress;
                this.mount = mount;
                this.path = path;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DedupEntry that = (DedupEntry)o;
                return Objects.equals(this.inetAddress, that.inetAddress) && Objects.equals(this.mount, that.mount) && Objects.equals(this.path, that.path);
            }

            public int hashCode() {
                return Objects.hash(this.inetAddress, this.mount, this.path);
            }
        }
    }

    public static class Counts
    implements ToXContentFragment {
        static final String COORDINATING_ONLY = "coordinating_only";
        private final int total;
        private final Map<String, Integer> roles;

        private Counts(List<NodeInfo> nodeInfos) {
            HashMap<String, Integer> roles = new HashMap<String, Integer>(DiscoveryNode.getPossibleRoleNames().size());
            roles.put(COORDINATING_ONLY, 0);
            for (String possibleRoleName : DiscoveryNode.getPossibleRoleNames()) {
                roles.put(possibleRoleName, 0);
            }
            int total = 0;
            for (NodeInfo nodeInfo : nodeInfos) {
                ++total;
                if (nodeInfo.getNode().getRoles().isEmpty()) {
                    roles.merge(COORDINATING_ONLY, 1, Integer::sum);
                    continue;
                }
                for (DiscoveryNodeRole role : nodeInfo.getNode().getRoles()) {
                    roles.merge(role.roleName(), 1, Integer::sum);
                }
            }
            this.total = total;
            this.roles = Collections.unmodifiableMap(new HashMap(roles));
        }

        public int getTotal() {
            return this.total;
        }

        public Map<String, Integer> getRoles() {
            return this.roles;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            for (Map.Entry<String, Integer> entry : new TreeMap<String, Integer>(this.roles).entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            return builder;
        }

        static final class Fields {
            static final String TOTAL = "total";

            Fields() {
            }
        }
    }

    public static class OsStats
    implements ToXContentFragment {
        final int availableProcessors;
        final int allocatedProcessors;
        final ObjectIntHashMap<String> names = new ObjectIntHashMap();
        final ObjectIntHashMap<String> prettyNames = new ObjectIntHashMap();
        final ObjectIntHashMap<String> architectures = new ObjectIntHashMap();
        final OsStats.Mem mem;

        private OsStats(List<NodeInfo> nodeInfos, List<NodeStats> nodeStatsList) {
            int availableProcessors = 0;
            int allocatedProcessors = 0;
            for (NodeInfo nodeInfo : nodeInfos) {
                availableProcessors += nodeInfo.getInfo(OsInfo.class).getAvailableProcessors();
                allocatedProcessors += nodeInfo.getInfo(OsInfo.class).getAllocatedProcessors();
                if (nodeInfo.getInfo(OsInfo.class).getName() != null) {
                    this.names.addTo((Object)nodeInfo.getInfo(OsInfo.class).getName(), 1);
                }
                if (nodeInfo.getInfo(OsInfo.class).getPrettyName() != null) {
                    this.prettyNames.addTo((Object)nodeInfo.getInfo(OsInfo.class).getPrettyName(), 1);
                }
                if (nodeInfo.getInfo(OsInfo.class).getArch() == null) continue;
                this.architectures.addTo((Object)nodeInfo.getInfo(OsInfo.class).getArch(), 1);
            }
            this.availableProcessors = availableProcessors;
            this.allocatedProcessors = allocatedProcessors;
            long totalMemory = 0L;
            long freeMemory = 0L;
            for (NodeStats nodeStats : nodeStatsList) {
                long free;
                if (nodeStats.getOs() == null) continue;
                long total = nodeStats.getOs().getMem().getTotal().getBytes();
                if (total > 0L) {
                    totalMemory += total;
                }
                if ((free = nodeStats.getOs().getMem().getFree().getBytes()) <= 0L) continue;
                freeMemory += free;
            }
            this.mem = new OsStats.Mem(totalMemory, freeMemory);
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public int getAllocatedProcessors() {
            return this.allocatedProcessors;
        }

        public OsStats.Mem getMem() {
            return this.mem;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("available_processors", this.availableProcessors);
            builder.field("allocated_processors", this.allocatedProcessors);
            builder.startArray("names");
            for (ObjectIntCursor name : this.names) {
                builder.startObject();
                builder.field("name", (String)name.key);
                builder.field("count", name.value);
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("pretty_names");
            for (ObjectIntCursor prettyName : this.prettyNames) {
                builder.startObject();
                builder.field("pretty_name", (String)prettyName.key);
                builder.field("count", prettyName.value);
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("architectures");
            for (ObjectIntCursor arch : this.architectures) {
                builder.startObject();
                builder.field("arch", (String)arch.key);
                builder.field("count", arch.value);
                builder.endObject();
            }
            builder.endArray();
            this.mem.toXContent(builder, params);
            return builder;
        }

        static final class Fields {
            static final String AVAILABLE_PROCESSORS = "available_processors";
            static final String ALLOCATED_PROCESSORS = "allocated_processors";
            static final String NAME = "name";
            static final String NAMES = "names";
            static final String PRETTY_NAME = "pretty_name";
            static final String PRETTY_NAMES = "pretty_names";
            static final String ARCH = "arch";
            static final String ARCHITECTURES = "architectures";
            static final String COUNT = "count";

            Fields() {
            }
        }
    }

    public static class ProcessStats
    implements ToXContentFragment {
        final int count;
        final int cpuPercent;
        final long totalOpenFileDescriptors;
        final long minOpenFileDescriptors;
        final long maxOpenFileDescriptors;

        private ProcessStats(List<NodeStats> nodeStatsList) {
            int count = 0;
            int cpuPercent = 0;
            long totalOpenFileDescriptors = 0L;
            long minOpenFileDescriptors = Long.MAX_VALUE;
            long maxOpenFileDescriptors = Long.MIN_VALUE;
            for (NodeStats nodeStats : nodeStatsList) {
                long fd;
                if (nodeStats.getProcess() == null) continue;
                ++count;
                if (nodeStats.getProcess().getCpu() != null) {
                    cpuPercent += nodeStats.getProcess().getCpu().getPercent();
                }
                if ((fd = nodeStats.getProcess().getOpenFileDescriptors()) > 0L) {
                    totalOpenFileDescriptors += fd;
                }
                minOpenFileDescriptors = Math.min(minOpenFileDescriptors, fd);
                maxOpenFileDescriptors = Math.max(maxOpenFileDescriptors, fd);
            }
            this.count = count;
            this.cpuPercent = cpuPercent;
            this.totalOpenFileDescriptors = totalOpenFileDescriptors;
            this.minOpenFileDescriptors = minOpenFileDescriptors;
            this.maxOpenFileDescriptors = maxOpenFileDescriptors;
        }

        public int getCpuPercent() {
            return this.cpuPercent;
        }

        public long getAvgOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.totalOpenFileDescriptors / (long)this.count;
        }

        public long getMaxOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.maxOpenFileDescriptors;
        }

        public long getMinOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.minOpenFileDescriptors;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cpu").field("percent", this.cpuPercent).endObject();
            if (this.count > 0) {
                builder.startObject("open_file_descriptors");
                builder.field("min", this.getMinOpenFileDescriptors());
                builder.field("max", this.getMaxOpenFileDescriptors());
                builder.field("avg", this.getAvgOpenFileDescriptors());
                builder.endObject();
            }
            return builder;
        }

        static final class Fields {
            static final String CPU = "cpu";
            static final String PERCENT = "percent";
            static final String OPEN_FILE_DESCRIPTORS = "open_file_descriptors";
            static final String MIN = "min";
            static final String MAX = "max";
            static final String AVG = "avg";

            Fields() {
            }
        }
    }

    public static class JvmStats
    implements ToXContentFragment {
        private final ObjectIntHashMap<JvmVersion> versions = new ObjectIntHashMap();
        private final long threads;
        private final long maxUptime;
        private final long heapUsed;
        private final long heapMax;

        private JvmStats(List<NodeInfo> nodeInfos, List<NodeStats> nodeStatsList) {
            long threads = 0L;
            long maxUptime = 0L;
            long heapMax = 0L;
            long heapUsed = 0L;
            for (NodeInfo nodeInfo : nodeInfos) {
                this.versions.addTo((Object)new JvmVersion(nodeInfo.getInfo(JvmInfo.class)), 1);
            }
            for (NodeStats nodeStats : nodeStatsList) {
                org.elasticsearch.monitor.jvm.JvmStats js = nodeStats.getJvm();
                if (js == null) continue;
                if (js.getThreads() != null) {
                    threads += (long)js.getThreads().getCount();
                }
                maxUptime = Math.max(maxUptime, js.getUptime().millis());
                if (js.getMem() == null) continue;
                heapUsed += js.getMem().getHeapUsed().getBytes();
                heapMax += js.getMem().getHeapMax().getBytes();
            }
            this.threads = threads;
            this.maxUptime = maxUptime;
            this.heapUsed = heapUsed;
            this.heapMax = heapMax;
        }

        public ObjectIntHashMap<JvmVersion> getVersions() {
            return this.versions;
        }

        public long getThreads() {
            return this.threads;
        }

        public TimeValue getMaxUpTime() {
            return new TimeValue(this.maxUptime);
        }

        public ByteSizeValue getHeapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.humanReadableField("max_uptime_in_millis", "max_uptime", (Object)new TimeValue(this.maxUptime));
            builder.startArray("versions");
            for (ObjectIntCursor v : this.versions) {
                builder.startObject();
                builder.field("version", ((JvmVersion)v.key).version);
                builder.field("vm_name", ((JvmVersion)v.key).vmName);
                builder.field("vm_version", ((JvmVersion)v.key).vmVersion);
                builder.field("vm_vendor", ((JvmVersion)v.key).vmVendor);
                builder.field("bundled_jdk", ((JvmVersion)v.key).bundledJdk);
                builder.field("using_bundled_jdk", ((JvmVersion)v.key).usingBundledJdk);
                builder.field("count", v.value);
                builder.endObject();
            }
            builder.endArray();
            builder.startObject("mem");
            builder.humanReadableField("heap_used_in_bytes", "heap_used", (Object)this.getHeapUsed());
            builder.humanReadableField("heap_max_in_bytes", "heap_max", (Object)this.getHeapMax());
            builder.endObject();
            builder.field("threads", this.threads);
            return builder;
        }

        static final class Fields {
            static final String VERSIONS = "versions";
            static final String VERSION = "version";
            static final String VM_NAME = "vm_name";
            static final String VM_VERSION = "vm_version";
            static final String VM_VENDOR = "vm_vendor";
            static final String BUNDLED_JDK = "bundled_jdk";
            static final String USING_BUNDLED_JDK = "using_bundled_jdk";
            static final String COUNT = "count";
            static final String THREADS = "threads";
            static final String MAX_UPTIME = "max_uptime";
            static final String MAX_UPTIME_IN_MILLIS = "max_uptime_in_millis";
            static final String MEM = "mem";
            static final String HEAP_USED = "heap_used";
            static final String HEAP_USED_IN_BYTES = "heap_used_in_bytes";
            static final String HEAP_MAX = "heap_max";
            static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";

            Fields() {
            }
        }
    }

    static class NetworkTypes
    implements ToXContentFragment {
        private final Map<String, AtomicInteger> transportTypes;
        private final Map<String, AtomicInteger> httpTypes;

        NetworkTypes(List<NodeInfo> nodeInfos) {
            HashMap<String, AtomicInteger> transportTypes = new HashMap<String, AtomicInteger>();
            HashMap<String, AtomicInteger> httpTypes = new HashMap<String, AtomicInteger>();
            for (NodeInfo nodeInfo : nodeInfos) {
                Settings settings = nodeInfo.getSettings();
                String transportType = settings.get("transport.type", NetworkModule.TRANSPORT_DEFAULT_TYPE_SETTING.get(settings));
                String httpType = settings.get("http.type", NetworkModule.HTTP_DEFAULT_TYPE_SETTING.get(settings));
                if (Strings.hasText(transportType)) {
                    transportTypes.computeIfAbsent(transportType, k -> new AtomicInteger()).incrementAndGet();
                }
                if (!Strings.hasText(httpType)) continue;
                httpTypes.computeIfAbsent(httpType, k -> new AtomicInteger()).incrementAndGet();
            }
            this.transportTypes = Collections.unmodifiableMap(transportTypes);
            this.httpTypes = Collections.unmodifiableMap(httpTypes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("transport_types");
            for (Map.Entry<String, AtomicInteger> entry : this.transportTypes.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().get());
            }
            builder.endObject();
            builder.startObject("http_types");
            for (Map.Entry<String, AtomicInteger> entry : this.httpTypes.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().get());
            }
            builder.endObject();
            return builder;
        }
    }

    static class DiscoveryTypes
    implements ToXContentFragment {
        private final Map<String, AtomicInteger> discoveryTypes;

        DiscoveryTypes(List<NodeInfo> nodeInfos) {
            HashMap<String, AtomicInteger> discoveryTypes = new HashMap<String, AtomicInteger>();
            for (NodeInfo nodeInfo : nodeInfos) {
                Settings settings = nodeInfo.getSettings();
                String discoveryType = DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings);
                discoveryTypes.computeIfAbsent(discoveryType, k -> new AtomicInteger()).incrementAndGet();
            }
            this.discoveryTypes = Collections.unmodifiableMap(discoveryTypes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("discovery_types");
            for (Map.Entry<String, AtomicInteger> entry : this.discoveryTypes.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().get());
            }
            builder.endObject();
            return builder;
        }
    }

    static class PackagingTypes
    implements ToXContentFragment {
        private final Map<Tuple<String, String>, AtomicInteger> packagingTypes;

        PackagingTypes(List<NodeInfo> nodeInfos) {
            HashMap<Tuple, AtomicInteger> packagingTypes = new HashMap<Tuple, AtomicInteger>();
            for (NodeInfo nodeInfo : nodeInfos) {
                String flavor = nodeInfo.getBuild().flavor().displayName();
                String type = nodeInfo.getBuild().type().displayName();
                packagingTypes.computeIfAbsent(Tuple.tuple((Object)flavor, (Object)type), k -> new AtomicInteger()).incrementAndGet();
            }
            this.packagingTypes = Collections.unmodifiableMap(packagingTypes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("packaging_types");
            for (Map.Entry<Tuple<String, String>, AtomicInteger> entry : this.packagingTypes.entrySet()) {
                builder.startObject();
                builder.field("flavor", (String)entry.getKey().v1());
                builder.field("type", (String)entry.getKey().v2());
                builder.field("count", entry.getValue().get());
                builder.endObject();
            }
            builder.endArray();
            return builder;
        }
    }

    static class IngestStats
    implements ToXContentFragment {
        final int pipelineCount;
        final SortedMap<String, long[]> stats;

        IngestStats(List<NodeStats> nodeStats) {
            HashSet<String> pipelineIds = new HashSet<String>();
            TreeMap<String, long[]> stats = new TreeMap<String, long[]>();
            for (NodeStats nodeStat : nodeStats) {
                if (nodeStat.getIngestStats() == null) continue;
                for (Map.Entry<String, List<IngestStats.ProcessorStat>> processorStats : nodeStat.getIngestStats().getProcessorStats().entrySet()) {
                    pipelineIds.add(processorStats.getKey());
                    for (IngestStats.ProcessorStat stat : processorStats.getValue()) {
                        stats.compute(stat.getType(), (k, v) -> {
                            IngestStats.Stats nodeIngestStats = stat.getStats();
                            if (v == null) {
                                return new long[]{nodeIngestStats.getIngestCount(), nodeIngestStats.getIngestFailedCount(), nodeIngestStats.getIngestCurrent(), nodeIngestStats.getIngestTimeInMillis()};
                            }
                            v[0] = v[0] + nodeIngestStats.getIngestCount();
                            v[1] = v[1] + nodeIngestStats.getIngestFailedCount();
                            v[2] = v[2] + nodeIngestStats.getIngestCurrent();
                            v[3] = v[3] + nodeIngestStats.getIngestTimeInMillis();
                            return v;
                        });
                    }
                }
            }
            this.pipelineCount = pipelineIds.size();
            this.stats = Collections.unmodifiableSortedMap(stats);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("ingest");
            builder.field("number_of_pipelines", this.pipelineCount);
            builder.startObject("processor_stats");
            for (Map.Entry<String, long[]> stat : this.stats.entrySet()) {
                long[] statValues = stat.getValue();
                builder.startObject(stat.getKey());
                builder.field("count", statValues[0]);
                builder.field("failed", statValues[1]);
                builder.field("current", statValues[2]);
                builder.humanReadableField("time_in_millis", "time", (Object)new TimeValue(statValues[3], TimeUnit.MILLISECONDS));
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }
    }

    static final class Fields {
        static final String COUNT = "count";
        static final String VERSIONS = "versions";
        static final String OS = "os";
        static final String PROCESS = "process";
        static final String JVM = "jvm";
        static final String FS = "fs";
        static final String PLUGINS = "plugins";
        static final String NETWORK_TYPES = "network_types";

        Fields() {
        }
    }

    public static class JvmVersion {
        String version;
        String vmName;
        String vmVersion;
        String vmVendor;
        boolean bundledJdk;
        Boolean usingBundledJdk;

        JvmVersion(JvmInfo jvmInfo) {
            this.version = jvmInfo.version();
            this.vmName = jvmInfo.getVmName();
            this.vmVersion = jvmInfo.getVmVersion();
            this.vmVendor = jvmInfo.getVmVendor();
            this.bundledJdk = jvmInfo.getBundledJdk();
            this.usingBundledJdk = jvmInfo.getUsingBundledJdk();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JvmVersion jvm = (JvmVersion)o;
            return this.vmVersion.equals(jvm.vmVersion) && this.vmVendor.equals(jvm.vmVendor);
        }

        public int hashCode() {
            return this.vmVersion.hashCode();
        }
    }
}

