/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class OpenPointInTimeResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ConstructingObjectParser<OpenPointInTimeResponse, Void> PARSER = new ConstructingObjectParser("open_point_in_time", true, a -> new OpenPointInTimeResponse((String)a[0]));
    private final String pointInTimeId;

    public OpenPointInTimeResponse(String pointInTimeId) {
        this.pointInTimeId = Objects.requireNonNull(pointInTimeId, "Point in time parameter must be not null");
    }

    public OpenPointInTimeResponse(StreamInput in) throws IOException {
        super(in);
        this.pointInTimeId = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.pointInTimeId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.pointInTimeId);
        builder.endObject();
        return builder;
    }

    public String getPointInTimeId() {
        return this.pointInTimeId;
    }

    public static OpenPointInTimeResponse fromXContent(XContentParser parser) throws IOException {
        return (OpenPointInTimeResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.text(), ID, ObjectParser.ValueType.STRING);
    }
}

