/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.TimedRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class PutMappingRequest
extends TimedRequest
implements IndicesRequest,
ToXContentObject {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)true);
    private final String[] indices;
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private BytesReference source;
    private XContentType xContentType;

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public PutMappingRequest source(Map<String, ?> mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(mappingSource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + mappingSource + "]", (Throwable)e);
        }
    }

    public PutMappingRequest source(String mappingSource, XContentType type) {
        this.source = new BytesArray(mappingSource);
        this.xContentType = type;
        return this;
    }

    public PutMappingRequest source(XContentBuilder builder) {
        this.source = BytesReference.bytes((XContentBuilder)builder);
        this.xContentType = builder.contentType();
        return this;
    }

    public PutMappingRequest source(BytesReference bytesReference, XContentType type) {
        this.source = bytesReference;
        this.xContentType = type;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            try (StreamInput stream = this.source.streamInput();){
                builder.rawValue((InputStream)stream, this.xContentType);
            }
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

