/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

@Description(name="avg", value="_FUNC_(expr) - Returns the average value of expr (vectorized, type: decimal64)")
public class VectorUDAFAvgDecimal64ToDecimalComplete
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private int inputScale;
    private DecimalTypeInfo outputDecimalTypeInfo;
    private final transient HiveDecimalWritable temp = new HiveDecimalWritable();

    public VectorUDAFAvgDecimal64ToDecimalComplete() {
    }

    public VectorUDAFAvgDecimal64ToDecimalComplete(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        Preconditions.checkState(this.mode == GenericUDAFEvaluator.Mode.COMPLETE);
        this.init();
    }

    private void init() {
        this.inputScale = ((DecimalTypeInfo)this.inputTypeInfo).getScale();
        this.outputDecimalTypeInfo = (DecimalTypeInfo)this.outputTypeInfo;
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(bufferIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        Decimal64ColumnVector inputVector = (Decimal64ColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        long[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.avgValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.avgValue(values[selection[i]]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.avgValue(values[i]);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long value, int batchSize, int[] selection, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.avgValue(value);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long value, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.avgValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, j);
            myagg.avgValue(values[i]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.avgValue(values[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        Decimal64ColumnVector inputVector = (Decimal64ColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        long[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                long value = vector[0];
                for (int i = 0; i < batchSize; ++i) {
                    myagg.avgValue(value);
                }
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            myagg.avgValue(vector[i]);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.avgValue(vector[selected[i]]);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            myagg.avgValue(vector[i]);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.avgValue(vector[i]);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation(this.inputScale, this.temp);
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2() * 2, model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("avg") && inputColVectorType == ColumnVector.Type.DECIMAL_64 && outputColVectorType == ColumnVector.Type.DECIMAL && mode == GenericUDAFEvaluator.Mode.COMPLETE;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        boolean isNull;
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (!myagg.isNull) {
            if (!myagg.usingRegularDecimal) {
                myagg.regularDecimalSum.deserialize64(myagg.sum, this.inputScale);
            } else {
                myagg.temp.deserialize64(myagg.sum, this.inputScale);
                myagg.regularDecimalSum.mutateAdd(myagg.temp);
            }
            isNull = !myagg.regularDecimalSum.isSet();
        } else {
            isNull = true;
        }
        if (isNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        Preconditions.checkState(myagg.count > 0L);
        outputColVector.isNull[batchIndex] = false;
        this.temp.setFromLong(myagg.count);
        HiveDecimalWritable result = outputColVector.vector[batchIndex];
        result.set(myagg.regularDecimalSum);
        result.mutateDivide(this.temp);
        result.mutateEnforcePrecisionScale(this.outputDecimalTypeInfo.getPrecision(), this.outputDecimalTypeInfo.getScale());
        if (!result.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
        }
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private static final long nearDecimal64Max = HiveDecimalWritable.getDecimal64AbsMax(17);
        private final int inputScale;
        private final HiveDecimalWritable temp;
        private long sum;
        private final HiveDecimalWritable regularDecimalSum = new HiveDecimalWritable(0L);
        private transient long count;
        private boolean isNull = true;
        private boolean usingRegularDecimal = false;

        public Aggregation(int inputScale, HiveDecimalWritable temp) {
            this.inputScale = inputScale;
            this.temp = temp;
        }

        public void avgValue(long value) {
            if (this.isNull) {
                this.sum = value;
                this.count = 1L;
                this.isNull = false;
            } else {
                if (Math.abs(this.sum) > nearDecimal64Max) {
                    if (!this.usingRegularDecimal) {
                        this.usingRegularDecimal = true;
                        this.regularDecimalSum.deserialize64(this.sum, this.inputScale);
                    } else {
                        this.temp.deserialize64(this.sum, this.inputScale);
                        this.regularDecimalSum.mutateAdd(this.temp);
                    }
                    this.sum = value;
                } else {
                    this.sum += value;
                }
                ++this.count;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.usingRegularDecimal = false;
            this.sum = 0L;
            this.regularDecimalSum.setFromLong(0L);
            this.count = 0L;
        }
    }
}

