/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.om.multitenant.AccountNameSpace;
import org.apache.hadoop.ozone.om.multitenant.BucketNameSpace;
import org.apache.hadoop.ozone.om.multitenant.Tenant;
import org.apache.hadoop.ozone.om.multitenant.impl.AccountNameSpaceImpl;
import org.apache.hadoop.ozone.om.multitenant.impl.SingleVolumeTenantNamespace;

public class OzoneTenant
implements Tenant {
    private final String tenantId;
    private final List<String> tenantRoleNames;
    private final List<String> accessPolicies;
    private final AccountNameSpace accountNameSpace;
    private final BucketNameSpace bucketNameSpace;

    public OzoneTenant(String id) {
        this.tenantId = id;
        this.accessPolicies = new ArrayList<String>();
        this.tenantRoleNames = new ArrayList<String>();
        this.accountNameSpace = new AccountNameSpaceImpl(id);
        this.bucketNameSpace = new SingleVolumeTenantNamespace(id);
    }

    @Override
    public String getTenantName() {
        return this.tenantId;
    }

    @Override
    public AccountNameSpace getTenantAccountNameSpace() {
        return this.accountNameSpace;
    }

    @Override
    public BucketNameSpace getTenantBucketNameSpace() {
        return this.bucketNameSpace;
    }

    @Override
    public List<String> getTenantAccessPolicies() {
        return this.accessPolicies;
    }

    @Override
    public void addTenantAccessPolicy(String policy) {
        this.accessPolicies.add(policy);
    }

    @Override
    public void removeTenantAccessPolicy(String policy) {
        this.accessPolicies.remove(policy);
    }

    @Override
    public void addTenantAccessRole(String roleName) {
        this.tenantRoleNames.add(roleName);
    }

    @Override
    public void removeTenantAccessRole(String roleName) {
        this.tenantRoleNames.remove(roleName);
    }

    @Override
    public List<String> getTenantRoles() {
        return this.tenantRoleNames;
    }

    public String toString() {
        return "OzoneTenant{tenantId='" + this.tenantId + '\'' + ", tenantRoleNames=" + this.tenantRoleNames + ", accessPolicies=" + this.accessPolicies + ", accountNameSpace=" + this.accountNameSpace + ", bucketNameSpace=" + this.bucketNameSpace + '}';
    }
}

