/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css.semantics;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSNamespaceDefinition;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.css.ICSSSelector;
import org.apache.royale.compiler.css.ICSSSelectorCondition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSSelector;
import org.apache.royale.compiler.internal.css.CSSStringPropertyValue;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.targets.Target;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnitFactory;
import org.apache.royale.compiler.mxml.IXMLNameResolver;
import org.apache.royale.compiler.problems.CSSEmbedAssetProblem;
import org.apache.royale.compiler.problems.CSSExcludedStylePropertyProblem;
import org.apache.royale.compiler.problems.CSSUndefinedNamespacePrefixProblem;
import org.apache.royale.compiler.problems.CSSUndefinedTypeProblem;
import org.apache.royale.compiler.problems.CSSUnknownDefaultNamespaceProblem;
import org.apache.royale.compiler.problems.CSSUnresolvedClassReferenceProblem;
import org.apache.royale.compiler.problems.CSSUnusedTypeSelectorProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.projects.IRoyaleProject;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.utils.FilenameNormalization;

public class CSSSemanticAnalyzer {
    private static final String GLOBAL_SELECTOR = "global";
    private static final String UNIVERSAL_SELECTOR = "*";
    private static final Function<String, String> QNAME_TO_SIMPLE_NAME = new Function<String, String>(){

        public String apply(String qname) {
            return (String)Iterables.getLast((Iterable)Splitter.on((String)".").omitEmptyStrings().split((CharSequence)qname));
        }
    };

    public static void resolveDependencies(Map<CSSFunctionCallPropertyValue, EmbedCompilationUnit> resolvedEmbedProperties, ICSSRule cssRule, ICompilerProject project, Set<IClassDefinition> classReferences, Set<EmbedCompilationUnit> embedCompilationUnits, Collection<ICompilerProblem> problems) {
        assert (cssRule != null) : "CSS rule can't be null";
        assert (project != null) : "Project can't be null";
        assert (problems != null) : "Problems can't be null";
        assert (classReferences != null) : "Expected an output collection for ClassReferences.";
        assert (embedCompilationUnits != null) : "Expected an output collection for Embed.";
        for (ICSSProperty property : cssRule.getProperties()) {
            ICSSPropertyValue propertyValue = property.getValue();
            if (!(propertyValue instanceof CSSFunctionCallPropertyValue)) continue;
            CSSFunctionCallPropertyValue functionCall = (CSSFunctionCallPropertyValue)propertyValue;
            if ("ClassReference".equals(functionCall.name)) {
                if ("null".equals(functionCall.rawArguments)) continue;
                String qName = CSSStringPropertyValue.isQuoted(functionCall.rawArguments) ? CSSStringPropertyValue.stripQuotes(functionCall.rawArguments) : functionCall.rawArguments;
                IDefinition definition = project.resolveQNameToDefinition(qName);
                if (definition != null && definition instanceof IClassDefinition) {
                    classReferences.add((IClassDefinition)definition);
                    continue;
                }
                CSSUnresolvedClassReferenceProblem problem = new CSSUnresolvedClassReferenceProblem(functionCall);
                problems.add(problem);
                continue;
            }
            if (!"Embed".equals(functionCall.name)) continue;
            String embedMetadata = String.format("[%s(%s)]", functionCall.name, functionCall.rawArguments);
            String sourcePath = FilenameNormalization.normalize(functionCall.getSourcePath());
            MetaTagsNode metadata = ASParser.parseMetadata(project.getWorkspace(), embedMetadata, sourcePath, functionCall.getStart(), functionCall.getLine(), functionCall.getColumn(), problems);
            IMetaTagNode embedTag = metadata.getTagByName("Embed");
            if (embedTag == null) {
                problems.add(new CSSEmbedAssetProblem(functionCall));
                continue;
            }
            try {
                EmbedCompilationUnit embedCompilationUnit = EmbedCompilationUnitFactory.getCompilationUnit((ASProject)project, embedTag.getSourcePath(), functionCall, embedTag.getAllAttributes(), problems);
                if (embedCompilationUnit == null) {
                    problems.add(new CSSEmbedAssetProblem(functionCall));
                    continue;
                }
                resolvedEmbedProperties.put(functionCall, embedCompilationUnit);
                embedCompilationUnits.add(embedCompilationUnit);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ImmutableMap<ICSSSelector, String> resolveSelectors(IXMLNameResolver xmlNameResolver, ICSSDocument css, Collection<ICompilerProblem> problems, IRoyaleProject project, boolean isCompatibilityVersion3) {
        assert (xmlNameResolver != null) : "Expected xmlNameResolver";
        assert (css != null) : "Expected CSS";
        ImmutableSet<ICSSSelector> allSelectors = CSSSemanticAnalyzer.getAllSelectors(css, project);
        if (isCompatibilityVersion3) {
            return CSSSemanticAnalyzer.resolveSelectorsAsFlex3Style(allSelectors);
        }
        ICSSNamespaceDefinition defaultNamespace = css.getDefaultNamespaceDefinition();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ICSSSelector selector : allSelectors) {
            ICSSNamespaceDefinition namespace;
            if (CSSSemanticAnalyzer.isWildcardSelector(selector)) continue;
            String prefix = selector.getNamespacePrefix();
            if (prefix == null) {
                if (defaultNamespace == null) {
                    problems.add(new CSSUnknownDefaultNamespaceProblem((CSSSelector)selector));
                    continue;
                }
                namespace = defaultNamespace;
            } else {
                namespace = css.getNamespaceDefinition(prefix);
            }
            if (namespace == null) {
                problems.add(new CSSUndefinedNamespacePrefixProblem((CSSSelector)selector));
                continue;
            }
            assert (selector.getElementName() != null) : "Null element name should be skipped as a wildcard selector.";
            XMLName xmlName = new XMLName(namespace.getURI(), selector.getElementName());
            String qname = xmlNameResolver.resolveXMLNameToQualifiedName(xmlName, MXMLDialect.MXML_2009);
            if (qname == null) {
                if (defaultNamespace != null && defaultNamespace.getURI().equals("http://www.w3.org/1999/xhtml")) {
                    builder.put((Object)selector, (Object)selector.getElementName());
                    continue;
                }
                problems.add(new CSSUndefinedTypeProblem((CSSSelector)selector));
                continue;
            }
            builder.put((Object)selector, (Object)qname);
        }
        return builder.build();
    }

    private static ImmutableMap<ICSSSelector, String> resolveSelectorsAsFlex3Style(Iterable<ICSSSelector> selectors) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ICSSSelector selector : selectors) {
            builder.put((Object)selector, (Object)selector.getCSSSyntax());
        }
        return builder.build();
    }

    public static ImmutableSet<ICSSSelector> getAllSelectors(ICSSDocument document, IRoyaleProject project) {
        assert (document != null) : "Expected CSS document";
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (ICSSRule rule : document.getRules()) {
            if (!project.isPlatformRule(rule)) continue;
            UnmodifiableIterator unmodifiableIterator = rule.getSelectorGroup().iterator();
            while (unmodifiableIterator.hasNext()) {
                ICSSSelector subject;
                ICSSSelector selector = subject = (ICSSSelector)unmodifiableIterator.next();
                while (selector != null) {
                    builder.add((Object)selector);
                    if (selector.getCombinator() != null) {
                        selector = selector.getCombinator().getSelector();
                        continue;
                    }
                    selector = null;
                }
            }
        }
        return builder.build();
    }

    public static ImmutableSet<ICSSRule> getMatchedRules(CSSCompilationSession session, IRoyaleProject royaleProject, ICSSDocument cssDocument, ImmutableSet<String> qnames, Collection<ICompilerProblem> problems) {
        Object predicate;
        boolean isFlex3CSS = royaleProject.getCSSManager().isFlex3CSS();
        ImmutableMap<ICSSSelector, String> resolvedSelectors = CSSSemanticAnalyzer.resolveSelectors(royaleProject, cssDocument, problems, royaleProject, isFlex3CSS);
        if (isFlex3CSS) {
            ImmutableSet simpleNames = ImmutableSet.copyOf((Collection)Collections2.transform(qnames, QNAME_TO_SIMPLE_NAME));
            predicate = new Flex3CSSRulePredicate((ImmutableSet<String>)simpleNames);
        } else {
            predicate = new MatchedCSSRulePredicate(qnames, royaleProject, resolvedSelectors);
        }
        session.resolvedSelectors.putAll((Map<ICSSSelector, String>)resolvedSelectors);
        return ImmutableSet.copyOf((Collection)Collections2.filter(cssDocument.getRules(), (Predicate)predicate));
    }

    public static boolean isWildcardSelector(ICSSSelector selector) {
        String elementName = selector.getElementName();
        return elementName == null || UNIVERSAL_SELECTOR.equals(elementName) || GLOBAL_SELECTOR.equals(elementName);
    }

    public static String getOptionalSelectorName(ICSSSelector selector) {
        int c;
        ImmutableList<ICSSSelectorCondition> conditions = selector.getConditions();
        if (conditions.size() == 0) {
            return null;
        }
        String elementName = ((ICSSSelectorCondition)conditions.get(0)).getValue();
        if (elementName == null) {
            return null;
        }
        if (elementName.startsWith("opt_") && (c = elementName.indexOf("_", 4)) >= 0) {
            return elementName.substring(4, c).replace("-", ".");
        }
        return null;
    }

    public static final ImmutableMap<String, IClassDefinition> buildQNameToDefinitionMap(Collection<IClassDefinition> classDefinitions) {
        HashMap<String, IClassDefinition> builder = new HashMap<String, IClassDefinition>();
        for (IClassDefinition classDefinition : classDefinitions) {
            builder.put(classDefinition.getQualifiedName(), classDefinition);
        }
        return ImmutableMap.copyOf(builder);
    }

    public static ImmutableSet<IClassDefinition> getClassDefinitionSet(Collection<IDefinition> definitions) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (IDefinition def : definitions) {
            if (!(def instanceof IClassDefinition)) continue;
            builder.add((Object)((IClassDefinition)def));
        }
        ImmutableSet classDefinitions = builder.build();
        return classDefinitions;
    }

    public static void validate(Set<ICompilationUnit> linkingCompilationUnits, CSSCompilationSession session, Collection<ICompilerProblem> problems) throws InterruptedException {
        CSSValidator validator = new CSSValidator(session, linkingCompilationUnits, problems);
        for (ICSSDocument cssDocument : session.cssDocuments) {
            CSSSemanticAnalyzer.visit(cssDocument, validator);
        }
    }

    private static void visit(ICSSDocument document, ICSSVisitor visitor) {
        visitor.beginDocument(document);
        for (ICSSRule rule : document.getRules()) {
            visitor.beginRule(rule);
            for (ICSSSelector selector : rule.getSelectorGroup()) {
                visitor.beginSubject(selector, rule);
            }
            for (ICSSProperty property : rule.getProperties()) {
                visitor.beginProperty(property, rule);
            }
        }
    }

    private static class Flex3CSSRulePredicate
    implements Predicate<ICSSRule> {
        private final ImmutableSet<String> definitionSimpleNames;

        private Flex3CSSRulePredicate(ImmutableSet<String> definitionSimpleNames) {
            this.definitionSimpleNames = definitionSimpleNames;
        }

        public boolean apply(ICSSRule rule) {
            for (ICSSSelector selector : rule.getSelectorGroup()) {
                if (selector.isAdvanced()) {
                    return false;
                }
                String elementName = selector.getElementName();
                if (CSSSemanticAnalyzer.GLOBAL_SELECTOR.equals(elementName) || elementName == null || this.definitionSimpleNames.contains((Object)elementName)) continue;
                return false;
            }
            return true;
        }

        public boolean test(ICSSRule input) {
            return this.apply(input);
        }
    }

    private static class MatchedCSSRulePredicate
    implements Predicate<ICSSRule> {
        private final IRoyaleProject project;
        private final ImmutableSet<String> qnames;
        private final ImmutableMap<ICSSSelector, String> resolvedSelectors;

        public MatchedCSSRulePredicate(ImmutableSet<String> qnames, IRoyaleProject project, ImmutableMap<ICSSSelector, String> resolvedSelectors) {
            assert (qnames != null) : "Expected a set of definition for the CSS rules to match.";
            assert (resolvedSelectors != null) : "Expected a map of selectors resolved to class definitions.";
            this.qnames = qnames;
            this.resolvedSelectors = resolvedSelectors;
            this.project = project;
        }

        public boolean apply(ICSSRule rule) {
            if (!this.project.isPlatformRule(rule)) {
                return false;
            }
            for (ICSSSelector selector : rule.getSelectorGroup()) {
                if (CSSSemanticAnalyzer.isWildcardSelector(selector)) {
                    String selName = CSSSemanticAnalyzer.getOptionalSelectorName(selector);
                    if (selName == null) {
                        return true;
                    }
                    return this.qnames.contains((Object)selName);
                }
                String qname = (String)this.resolvedSelectors.get((Object)selector);
                if (!this.qnames.contains((Object)qname)) continue;
                return true;
            }
            return false;
        }

        public boolean test(ICSSRule input) {
            return this.apply(input);
        }
    }

    private static class CSSValidator
    implements ICSSVisitor {
        private final CSSCompilationSession session;
        private final ImmutableMap<String, IClassDefinition> qnameToDefinition;
        private final Collection<ICompilerProblem> problems;
        private final Multimap<ICSSSelector, String> excludedStyles;

        private CSSValidator(CSSCompilationSession session, Set<ICompilationUnit> linkingCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            this.session = session;
            ImmutableList<IDefinition> linkingDefinitions = Target.getAllExternallyVisibleDefinitions(linkingCompilationUnits);
            ImmutableSet<IClassDefinition> classDefinitions = CSSSemanticAnalyzer.getClassDefinitionSet(linkingDefinitions);
            this.qnameToDefinition = CSSSemanticAnalyzer.buildQNameToDefinitionMap(classDefinitions);
            this.problems = problems;
            this.excludedStyles = HashMultimap.create();
        }

        @Override
        public void beginSubject(ICSSSelector selector, ICSSRule rule) {
            if (!CSSSemanticAnalyzer.isWildcardSelector(selector)) {
                String qname = this.session.resolvedSelectors.get(selector);
                if (this.qnameToDefinition.containsKey((Object)qname)) {
                    IMetaTag[] excludeMetaTags;
                    IClassDefinition classDefinition = (IClassDefinition)this.qnameToDefinition.get((Object)qname);
                    for (IMetaTag exclude : excludeMetaTags = classDefinition.getMetaTagsByName("Exclude")) {
                        String excludedStyleName;
                        String kind = exclude.getAttributeValue("kind");
                        if (!"style".equals(kind) || (excludedStyleName = exclude.getAttributeValue("name")) == null || excludedStyleName.isEmpty()) continue;
                        this.excludedStyles.put((Object)selector, (Object)excludedStyleName);
                    }
                } else {
                    this.problems.add(new CSSUnusedTypeSelectorProblem(selector));
                }
            }
        }

        @Override
        public void beginRule(ICSSRule rule) {
        }

        @Override
        public void beginDocument(ICSSDocument document) {
        }

        @Override
        public void beginProperty(ICSSProperty property, ICSSRule rule) {
            for (ICSSSelector subject : rule.getSelectorGroup()) {
                Collection excludedStylesForSubject = this.excludedStyles.get((Object)subject);
                if (excludedStylesForSubject == null || !excludedStylesForSubject.contains(property.getName())) continue;
                String qname = this.session.resolvedSelectors.get(subject);
                this.problems.add(new CSSExcludedStylePropertyProblem(property, qname));
            }
        }
    }

    private static interface ICSSVisitor {
        public void beginDocument(ICSSDocument var1);

        public void beginRule(ICSSRule var1);

        public void beginSubject(ICSSSelector var1, ICSSRule var2);

        public void beginProperty(ICSSProperty var1, ICSSRule var2);
    }
}

