/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.logical;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.serializable.JobDataSerializerHook;

public class LogicalVertex
implements IdentifiedDataSerializable {
    private Long vertexId;
    private Action action;
    private int parallelism;

    public LogicalVertex() {
    }

    public LogicalVertex(Long vertexId, Action action, int parallelism) {
        this.vertexId = vertexId;
        this.action = action;
        this.parallelism = parallelism;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalVertex that = (LogicalVertex)o;
        return Objects.equals(this.vertexId, that.vertexId) && Objects.equals(this.action, that.action);
    }

    public String toString() {
        return "LogicalVertex{jobVertexId=" + this.vertexId + ", action=" + this.action + ", parallelism=" + this.parallelism + '}';
    }

    public int hashCode() {
        return Objects.hash(this.vertexId, this.action);
    }

    public int getFactoryId() {
        return JobDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 1;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.vertexId.longValue());
        out.writeObject((Object)this.action);
        out.writeInt(this.parallelism);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.vertexId = in.readLong();
        this.action = (Action)in.readObject();
        this.parallelism = in.readInt();
    }

    public Long getVertexId() {
        return this.vertexId;
    }

    public Action getAction() {
        return this.action;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setVertexId(Long vertexId) {
        this.vertexId = vertexId;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }
}

