/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.ClusterVersionListener;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.dynamicconfig.AddDynamicConfigOperationSupplier;
import com.hazelcast.internal.dynamicconfig.ConfigCheckMode;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.dynamicconfig.DynamicConfigListener;
import com.hazelcast.internal.dynamicconfig.DynamicConfigPreJoinOperation;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.CoreService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.version.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class ClusterWideConfigurationService
implements PreJoinAwareService,
CoreService,
ClusterVersionListener,
ManagedService,
ConfigurationService,
SplitBrainHandlerService {
    public static final int CONFIG_PUBLISH_MAX_ATTEMPT_COUNT = 100;
    static final Map<Class<? extends IdentifiedDataSerializable>, Version> CONFIG_TO_VERSION;
    private static final boolean IGNORE_CONFLICTING_CONFIGS_WORKAROUND;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    private final DynamicConfigListener listener;
    private final ConcurrentMap<String, MapConfig> mapConfigs = new ConcurrentHashMap<String, MapConfig>();
    private final ConcurrentMap<String, MultiMapConfig> multiMapConfigs = new ConcurrentHashMap<String, MultiMapConfig>();
    private final ConcurrentMap<String, CardinalityEstimatorConfig> cardinalityEstimatorConfigs = new ConcurrentHashMap<String, CardinalityEstimatorConfig>();
    private final ConcurrentMap<String, PNCounterConfig> pnCounterConfigs = new ConcurrentHashMap<String, PNCounterConfig>();
    private final ConcurrentMap<String, RingbufferConfig> ringbufferConfigs = new ConcurrentHashMap<String, RingbufferConfig>();
    private final ConcurrentMap<String, ListConfig> listConfigs = new ConcurrentHashMap<String, ListConfig>();
    private final ConcurrentMap<String, SetConfig> setConfigs = new ConcurrentHashMap<String, SetConfig>();
    private final ConcurrentMap<String, ReplicatedMapConfig> replicatedMapConfigs = new ConcurrentHashMap<String, ReplicatedMapConfig>();
    private final ConcurrentMap<String, TopicConfig> topicConfigs = new ConcurrentHashMap<String, TopicConfig>();
    private final ConcurrentMap<String, ExecutorConfig> executorConfigs = new ConcurrentHashMap<String, ExecutorConfig>();
    private final ConcurrentMap<String, DurableExecutorConfig> durableExecutorConfigs = new ConcurrentHashMap<String, DurableExecutorConfig>();
    private final ConcurrentMap<String, ScheduledExecutorConfig> scheduledExecutorConfigs = new ConcurrentHashMap<String, ScheduledExecutorConfig>();
    private final ConcurrentMap<String, QueueConfig> queueConfigs = new ConcurrentHashMap<String, QueueConfig>();
    private final ConcurrentMap<String, ReliableTopicConfig> reliableTopicConfigs = new ConcurrentHashMap<String, ReliableTopicConfig>();
    private final ConcurrentMap<String, CacheSimpleConfig> cacheSimpleConfigs = new ConcurrentHashMap<String, CacheSimpleConfig>();
    private final ConcurrentMap<String, FlakeIdGeneratorConfig> flakeIdGeneratorConfigs = new ConcurrentHashMap<String, FlakeIdGeneratorConfig>();
    private final ConfigPatternMatcher configPatternMatcher;
    private final Map<?, ? extends IdentifiedDataSerializable>[] allConfigurations = new Map[]{this.mapConfigs, this.multiMapConfigs, this.cardinalityEstimatorConfigs, this.ringbufferConfigs, this.listConfigs, this.setConfigs, this.replicatedMapConfigs, this.topicConfigs, this.executorConfigs, this.durableExecutorConfigs, this.scheduledExecutorConfigs, this.queueConfigs, this.reliableTopicConfigs, this.cacheSimpleConfigs, this.flakeIdGeneratorConfigs, this.pnCounterConfigs};
    private volatile Version version;

    public ClusterWideConfigurationService(NodeEngine nodeEngine, DynamicConfigListener dynamicConfigListener) {
        this.nodeEngine = nodeEngine;
        this.listener = dynamicConfigListener;
        this.configPatternMatcher = nodeEngine.getConfig().getConfigPatternMatcher();
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public Operation getPreJoinOperation() {
        IdentifiedDataSerializable[] allConfigurations = this.collectAllDynamicConfigs();
        if (this.noConfigurationExist(allConfigurations)) {
            return null;
        }
        return new DynamicConfigPreJoinOperation(allConfigurations, ConfigCheckMode.WARNING);
    }

    private boolean noConfigurationExist(IdentifiedDataSerializable[] configurations) {
        return configurations.length == 0;
    }

    private IdentifiedDataSerializable[] collectAllDynamicConfigs() {
        ArrayList<? extends IdentifiedDataSerializable> all = new ArrayList<IdentifiedDataSerializable>();
        for (Map<?, IdentifiedDataSerializable> map : this.allConfigurations) {
            Collection<? extends IdentifiedDataSerializable> values = map.values();
            all.addAll(values);
        }
        return all.toArray(new IdentifiedDataSerializable[0]);
    }

    @Override
    public void onClusterVersionChange(Version newVersion) {
        this.version = newVersion;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.listener.onServiceInitialized(this);
    }

    @Override
    public void reset() {
        for (Map<?, IdentifiedDataSerializable> map : this.allConfigurations) {
            map.clear();
        }
    }

    @Override
    public void shutdown(boolean terminate) {
    }

    @Override
    public void broadcastConfig(IdentifiedDataSerializable config) {
        InternalCompletableFuture<Object> future = this.broadcastConfigAsync(config);
        future.joinInternal();
    }

    @Override
    public void updateLicense(String licenseKey) {
        throw new UnsupportedOperationException("Updating the license requires Hazelcast Enterprise");
    }

    @Override
    public ConfigUpdateResult update(@Nullable Config newConfig) {
        throw new UnsupportedOperationException("Configuration Reload requires Hazelcast Enterprise Edition");
    }

    @Override
    public UUID updateAsync(String configPatch) {
        throw new UnsupportedOperationException("Configuration Reload requires Hazelcast Enterprise Edition");
    }

    public InternalCompletableFuture<Object> broadcastConfigAsync(IdentifiedDataSerializable config) {
        this.checkConfigVersion(config);
        IdentifiedDataSerializable clonedConfig = this.cloneConfig(config);
        ClusterService clusterService = this.nodeEngine.getClusterService();
        return InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, new AddDynamicConfigOperationSupplier(clusterService, clonedConfig), 100);
    }

    private void checkConfigVersion(IdentifiedDataSerializable config) {
        Version currentClusterVersion = this.version;
        Class<?> configClass = config.getClass();
        Version introducedIn = CONFIG_TO_VERSION.get(configClass);
        if (currentClusterVersion.isLessThan(introducedIn)) {
            throw new UnsupportedOperationException(String.format("Config '%s' is available since version '%s'. Current cluster version '%s' does not allow dynamically adding '%1$s'.", configClass.getSimpleName(), introducedIn.toString(), currentClusterVersion));
        }
    }

    private IdentifiedDataSerializable cloneConfig(IdentifiedDataSerializable config) {
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        Object data = serializationService.toData(config);
        return (IdentifiedDataSerializable)serializationService.toObject(data);
    }

    public void registerConfigLocally(IdentifiedDataSerializable newConfig, ConfigCheckMode configCheckMode) {
        IdentifiedDataSerializable currentConfig;
        if (newConfig instanceof MultiMapConfig) {
            MultiMapConfig multiMapConfig = (MultiMapConfig)newConfig;
            currentConfig = this.multiMapConfigs.putIfAbsent(multiMapConfig.getName(), multiMapConfig);
        } else if (newConfig instanceof MapConfig) {
            MapConfig newMapConfig = (MapConfig)newConfig;
            currentConfig = this.mapConfigs.putIfAbsent(newMapConfig.getName(), newMapConfig);
            if (currentConfig == null) {
                this.listener.onConfigRegistered(newMapConfig);
            }
        } else if (newConfig instanceof CardinalityEstimatorConfig) {
            CardinalityEstimatorConfig cardinalityEstimatorConfig = (CardinalityEstimatorConfig)newConfig;
            currentConfig = this.cardinalityEstimatorConfigs.putIfAbsent(cardinalityEstimatorConfig.getName(), cardinalityEstimatorConfig);
        } else if (newConfig instanceof RingbufferConfig) {
            RingbufferConfig ringbufferConfig = (RingbufferConfig)newConfig;
            currentConfig = this.ringbufferConfigs.putIfAbsent(ringbufferConfig.getName(), ringbufferConfig);
        } else if (newConfig instanceof ListConfig) {
            ListConfig listConfig = (ListConfig)newConfig;
            currentConfig = this.listConfigs.putIfAbsent(listConfig.getName(), listConfig);
        } else if (newConfig instanceof SetConfig) {
            SetConfig setConfig = (SetConfig)newConfig;
            currentConfig = this.setConfigs.putIfAbsent(setConfig.getName(), setConfig);
        } else if (newConfig instanceof ReplicatedMapConfig) {
            ReplicatedMapConfig replicatedMapConfig = (ReplicatedMapConfig)newConfig;
            currentConfig = this.replicatedMapConfigs.putIfAbsent(replicatedMapConfig.getName(), replicatedMapConfig);
        } else if (newConfig instanceof TopicConfig) {
            TopicConfig topicConfig = (TopicConfig)newConfig;
            currentConfig = this.topicConfigs.putIfAbsent(topicConfig.getName(), topicConfig);
        } else if (newConfig instanceof ExecutorConfig) {
            ExecutorConfig executorConfig = (ExecutorConfig)newConfig;
            currentConfig = this.executorConfigs.putIfAbsent(executorConfig.getName(), executorConfig);
        } else if (newConfig instanceof DurableExecutorConfig) {
            DurableExecutorConfig durableExecutorConfig = (DurableExecutorConfig)newConfig;
            currentConfig = this.durableExecutorConfigs.putIfAbsent(durableExecutorConfig.getName(), durableExecutorConfig);
        } else if (newConfig instanceof ScheduledExecutorConfig) {
            ScheduledExecutorConfig scheduledExecutorConfig = (ScheduledExecutorConfig)newConfig;
            currentConfig = this.scheduledExecutorConfigs.putIfAbsent(scheduledExecutorConfig.getName(), scheduledExecutorConfig);
        } else if (newConfig instanceof QueueConfig) {
            QueueConfig queueConfig = (QueueConfig)newConfig;
            currentConfig = this.queueConfigs.putIfAbsent(queueConfig.getName(), queueConfig);
        } else if (newConfig instanceof ReliableTopicConfig) {
            ReliableTopicConfig reliableTopicConfig = (ReliableTopicConfig)newConfig;
            currentConfig = this.reliableTopicConfigs.putIfAbsent(reliableTopicConfig.getName(), reliableTopicConfig);
        } else if (newConfig instanceof CacheSimpleConfig) {
            CacheSimpleConfig cacheSimpleConfig = (CacheSimpleConfig)newConfig;
            currentConfig = this.cacheSimpleConfigs.putIfAbsent(cacheSimpleConfig.getName(), cacheSimpleConfig);
            if (currentConfig == null) {
                this.listener.onConfigRegistered(cacheSimpleConfig);
            }
        } else if (newConfig instanceof FlakeIdGeneratorConfig) {
            FlakeIdGeneratorConfig config = (FlakeIdGeneratorConfig)newConfig;
            currentConfig = this.flakeIdGeneratorConfigs.putIfAbsent(config.getName(), config);
        } else if (newConfig instanceof PNCounterConfig) {
            PNCounterConfig config = (PNCounterConfig)newConfig;
            currentConfig = this.pnCounterConfigs.putIfAbsent(config.getName(), config);
        } else {
            throw new UnsupportedOperationException("Unsupported config type: " + newConfig);
        }
        this.checkCurrentConfigNullOrEqual(configCheckMode, currentConfig, newConfig);
        this.persist(newConfig);
    }

    protected void checkCurrentConfigNullOrEqual(ConfigCheckMode checkMode, Object currentConfig, Object newConfig) {
        if (IGNORE_CONFLICTING_CONFIGS_WORKAROUND) {
            return;
        }
        if (currentConfig == null) {
            return;
        }
        if (!currentConfig.equals(newConfig)) {
            String message = "Cannot add a dynamic configuration '" + newConfig + "' as there is already a conflicting configuration '" + currentConfig + "'";
            switch (checkMode) {
                case THROW_EXCEPTION: {
                    throw new InvalidConfigurationException(message);
                }
                case WARNING: {
                    this.logger.warning(message);
                    break;
                }
                case SILENT: {
                    this.logger.finest(message);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown consistency check mode: " + (Object)((Object)checkMode));
                }
            }
        }
    }

    @Override
    public void persist(Object subConfig) {
        if (this.nodeEngine.getConfig().getDynamicConfigurationConfig().isPersistenceEnabled()) {
            throw new UnsupportedOperationException("Dynamic Configuration Persistence requires Hazelcast Enterprise Edition");
        }
    }

    @Override
    public MultiMapConfig findMultiMapConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.multiMapConfigs, name);
    }

    public ConcurrentMap<String, MultiMapConfig> getMultiMapConfigs() {
        return this.multiMapConfigs;
    }

    @Override
    public MapConfig findMapConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.mapConfigs, name);
    }

    @Override
    public Map<String, MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }

    @Override
    public TopicConfig findTopicConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.topicConfigs, name);
    }

    public ConcurrentMap<String, TopicConfig> getTopicConfigs() {
        return this.topicConfigs;
    }

    @Override
    public CardinalityEstimatorConfig findCardinalityEstimatorConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.cardinalityEstimatorConfigs, name);
    }

    public ConcurrentMap<String, CardinalityEstimatorConfig> getCardinalityEstimatorConfigs() {
        return this.cardinalityEstimatorConfigs;
    }

    @Override
    public PNCounterConfig findPNCounterConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.pnCounterConfigs, name);
    }

    public ConcurrentMap<String, PNCounterConfig> getPNCounterConfigs() {
        return this.pnCounterConfigs;
    }

    @Override
    public ExecutorConfig findExecutorConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.executorConfigs, name);
    }

    public ConcurrentMap<String, ExecutorConfig> getExecutorConfigs() {
        return this.executorConfigs;
    }

    @Override
    public ScheduledExecutorConfig findScheduledExecutorConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.scheduledExecutorConfigs, name);
    }

    public ConcurrentMap<String, ScheduledExecutorConfig> getScheduledExecutorConfigs() {
        return this.scheduledExecutorConfigs;
    }

    @Override
    public DurableExecutorConfig findDurableExecutorConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.durableExecutorConfigs, name);
    }

    public ConcurrentMap<String, DurableExecutorConfig> getDurableExecutorConfigs() {
        return this.durableExecutorConfigs;
    }

    @Override
    public RingbufferConfig findRingbufferConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.ringbufferConfigs, name);
    }

    public ConcurrentMap<String, RingbufferConfig> getRingbufferConfigs() {
        return this.ringbufferConfigs;
    }

    @Override
    public ListConfig findListConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.listConfigs, name);
    }

    public ConcurrentMap<String, ListConfig> getListConfigs() {
        return this.listConfigs;
    }

    @Override
    public QueueConfig findQueueConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.queueConfigs, name);
    }

    @Override
    public Map<String, QueueConfig> getQueueConfigs() {
        return this.queueConfigs;
    }

    @Override
    public SetConfig findSetConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.setConfigs, name);
    }

    public ConcurrentMap<String, SetConfig> getSetConfigs() {
        return this.setConfigs;
    }

    @Override
    public ReplicatedMapConfig findReplicatedMapConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.replicatedMapConfigs, name);
    }

    public ConcurrentMap<String, ReplicatedMapConfig> getReplicatedMapConfigs() {
        return this.replicatedMapConfigs;
    }

    @Override
    public ReliableTopicConfig findReliableTopicConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.reliableTopicConfigs, name);
    }

    public ConcurrentMap<String, ReliableTopicConfig> getReliableTopicConfigs() {
        return this.reliableTopicConfigs;
    }

    @Override
    public CacheSimpleConfig findCacheSimpleConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.cacheSimpleConfigs, name);
    }

    @Override
    public Map<String, CacheSimpleConfig> getCacheSimpleConfigs() {
        return this.cacheSimpleConfigs;
    }

    @Override
    public FlakeIdGeneratorConfig findFlakeIdGeneratorConfig(String baseName) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.flakeIdGeneratorConfigs, baseName);
    }

    @Override
    public Map<String, FlakeIdGeneratorConfig> getFlakeIdGeneratorConfigs() {
        return this.flakeIdGeneratorConfigs;
    }

    @Override
    public Runnable prepareMergeRunnable() {
        IdentifiedDataSerializable[] allConfigurations = this.collectAllDynamicConfigs();
        if (this.noConfigurationExist(allConfigurations)) {
            return null;
        }
        return new Merger(this.nodeEngine, allConfigurations);
    }

    private static Map<Class<? extends IdentifiedDataSerializable>, Version> initializeConfigToVersionMap() {
        HashMap<Class, Version> configToVersion = new HashMap<Class, Version>();
        configToVersion.put(MapConfig.class, Versions.V4_0);
        configToVersion.put(MultiMapConfig.class, Versions.V4_0);
        configToVersion.put(CardinalityEstimatorConfig.class, Versions.V4_0);
        configToVersion.put(RingbufferConfig.class, Versions.V4_0);
        configToVersion.put(ListConfig.class, Versions.V4_0);
        configToVersion.put(SetConfig.class, Versions.V4_0);
        configToVersion.put(ReplicatedMapConfig.class, Versions.V4_0);
        configToVersion.put(TopicConfig.class, Versions.V4_0);
        configToVersion.put(ExecutorConfig.class, Versions.V4_0);
        configToVersion.put(DurableExecutorConfig.class, Versions.V4_0);
        configToVersion.put(ScheduledExecutorConfig.class, Versions.V4_0);
        configToVersion.put(QueueConfig.class, Versions.V4_0);
        configToVersion.put(ReliableTopicConfig.class, Versions.V4_0);
        configToVersion.put(CacheSimpleConfig.class, Versions.V4_0);
        configToVersion.put(EventJournalConfig.class, Versions.V4_0);
        configToVersion.put(FlakeIdGeneratorConfig.class, Versions.V4_0);
        configToVersion.put(PNCounterConfig.class, Versions.V4_0);
        configToVersion.put(MerkleTreeConfig.class, Versions.V4_0);
        return Collections.unmodifiableMap(configToVersion);
    }

    static {
        IGNORE_CONFLICTING_CONFIGS_WORKAROUND = Boolean.getBoolean("hazelcast.dynamicconfig.ignore.conflicts");
        CONFIG_TO_VERSION = ClusterWideConfigurationService.initializeConfigToVersionMap();
    }

    public static class Merger
    implements Runnable {
        private final NodeEngine nodeEngine;
        private final IdentifiedDataSerializable[] allConfigurations;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public Merger(NodeEngine nodeEngine, IdentifiedDataSerializable[] allConfigurations) {
            this.nodeEngine = nodeEngine;
            this.allConfigurations = allConfigurations;
        }

        @Override
        public void run() {
            try {
                InternalCompletableFuture future = InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, () -> new DynamicConfigPreJoinOperation(this.allConfigurations, ConfigCheckMode.SILENT), 100);
                FutureUtil.waitForever(Collections.singleton(future), FutureUtil.RETHROW_EVERYTHING);
            }
            catch (Exception e) {
                throw new HazelcastException("Error while merging configurations", e);
            }
        }
    }
}

