/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.metrics;

import com.hazelcast.jet.core.metrics.Measurement;
import com.hazelcast.jet.core.metrics.MeasurementPredicates;
import com.hazelcast.jet.core.metrics.MetricsDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class JobMetrics
implements IdentifiedDataSerializable {
    private static final JobMetrics EMPTY = new JobMetrics(Collections.emptyMap());
    private static final Collector<Measurement, ?, Map<String, List<Measurement>>> COLLECTOR = Collectors.groupingBy(Measurement::metric);
    private Map<String, List<Measurement>> metrics;

    JobMetrics() {
    }

    private JobMetrics(@Nonnull Map<String, List<Measurement>> metrics) {
        this.metrics = new HashMap<String, List<Measurement>>(metrics);
    }

    @Nonnull
    @PrivateApi
    public static JobMetrics empty() {
        return EMPTY;
    }

    @Nonnull
    @PrivateApi
    public static JobMetrics of(@Nonnull Map<String, List<Measurement>> metrics) {
        return new JobMetrics(metrics);
    }

    @Nonnull
    public Set<String> metrics() {
        return Collections.unmodifiableSet(this.metrics.keySet());
    }

    @Nonnull
    public List<Measurement> get(@Nonnull String metricName) {
        Objects.requireNonNull(metricName);
        List<Measurement> measurements = this.metrics.get(metricName);
        return measurements == null ? Collections.emptyList() : measurements;
    }

    @Nonnull
    public JobMetrics filter(@Nonnull String tagName, @Nonnull String tagValue) {
        return this.filter(MeasurementPredicates.tagValueEquals(tagName, tagValue));
    }

    @Nonnull
    public JobMetrics filter(@Nonnull Predicate<Measurement> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Map<String, List<Measurement>> filteredMetrics = this.metrics.values().stream().flatMap(Collection::stream).filter(predicate).collect(COLLECTOR);
        return new JobMetrics(filteredMetrics);
    }

    @Override
    public int getFactoryId() {
        return MetricsDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.metrics);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.metrics = (Map)in.readObject();
    }

    public int hashCode() {
        return this.metrics.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Objects.equals(this.metrics, ((JobMetrics)obj).metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.metrics.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(mainEntry -> {
            sb.append((String)mainEntry.getKey()).append(":\n");
            ((List)mainEntry.getValue()).stream().collect(Collectors.groupingBy(m -> {
                String vertex = m.tag("vertex");
                return vertex == null ? "" : vertex;
            })).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> {
                String vertexName = (String)e.getKey();
                sb.append("  ").append(vertexName).append(":\n");
                ((List)e.getValue()).forEach(m -> sb.append("    ").append(m).append("\n"));
            });
        });
        return sb.toString();
    }
}

