/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.map.impl.record.SimpleRecord;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class CachedSimpleRecord
extends SimpleRecord<Data> {
    private static final AtomicReferenceFieldUpdater<CachedSimpleRecord, Object> CACHED_VALUE = AtomicReferenceFieldUpdater.newUpdater(CachedSimpleRecord.class, Object.class, "cachedValue");
    private volatile transient Object cachedValue;

    CachedSimpleRecord() {
    }

    CachedSimpleRecord(Data value) {
        super(value);
    }

    @Override
    public long getCost() {
        return super.getCost() + (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    }

    @Override
    public void setValue(Data o) {
        super.setValue(o);
        this.cachedValue = null;
    }

    @Override
    public Object getCachedValueUnsafe() {
        return this.cachedValue;
    }

    @Override
    public boolean casCachedValue(Object expectedValue, Object newValue) {
        return CACHED_VALUE.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CachedSimpleRecord that = (CachedSimpleRecord)o;
        return Objects.equals(this.cachedValue, that.cachedValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.cachedValue != null ? this.cachedValue.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CachedSimpleRecord{cachedValue=" + this.cachedValue + ", " + super.toString() + "} ";
    }
}

