/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.expression.math.MathFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandFunction
extends UniExpression<Double>
implements IdentifiedDataSerializable {
    public RandFunction() {
    }

    public RandFunction(Expression<?> seedExp) {
        super(seedExp);
    }

    public static RandFunction create(Expression<?> seedExp) {
        return new RandFunction(seedExp);
    }

    @Override
    public Double eval(Row row, ExpressionEvalContext context) {
        Long seed = this.operand != null ? MathFunctionUtils.asBigint(this.operand, row, context) : null;
        Random random = seed != null ? new Random(seed) : ThreadLocalRandom.current();
        return random.nextDouble();
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.DOUBLE;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 33;
    }
}

