/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.request.connector.ConnectorStatus;
import org.apache.seatunnel.app.domain.request.connector.SceneMode;
import org.apache.seatunnel.app.domain.response.connector.ConnectorInfo;
import org.apache.seatunnel.app.domain.response.connector.DataSourceInstance;
import org.apache.seatunnel.app.service.IConnectorService;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/seatunnel/api/v1/datasource"})
@RestController
public class ConnectorDataSourceController {
    @Resource
    private IConnectorService connectorService;

    @GetMapping(value={"/sources"})
    @ApiOperation(value="Use jobID to list source DataSourceInstance", httpMethod="GET")
    public Result<List<DataSourceInstance>> listSource(@ApiParam(value="jobCode", required=true) @RequestParam Long jobId, @ApiParam(value="SceneMode", required=true) @RequestParam SceneMode sceneMode, @ApiParam(value="ConnectorStatus", required=true) @RequestParam ConnectorStatus status) {
        return Result.success(this.connectorService.listSourceDataSourceInstances(jobId, sceneMode, status));
    }

    @GetMapping(value={"/sinks"})
    @ApiOperation(value="Use jobID to list sink DataSourceInstance", httpMethod="GET")
    public Result<List<DataSourceInstance>> listSink(@ApiParam(value="jobCode", required=true) @RequestParam Long jobId, @ApiParam(value="ConnectorStatus", required=true) @RequestParam ConnectorStatus status) {
        return Result.success(this.connectorService.listSinkDataSourcesInstances(jobId, status));
    }

    @GetMapping(value={"/transforms"})
    @ApiOperation(value="Use jobID to list  transforms", httpMethod="GET")
    public Result<List<ConnectorInfo>> listAllTransform(@ApiParam(value="jobCode", required=true) @RequestParam Long jobId) {
        return Result.success(this.connectorService.listTransformsForJob(jobId));
    }

    @GetMapping(value={"/sync"})
    @ApiOperation(value="sync all connector from disk", httpMethod="GET")
    public Result<List<ConnectorInfo>> sync() throws IOException {
        this.connectorService.sync();
        return Result.success();
    }

    @GetMapping(value={"/form"})
    @ApiOperation(value="get datasource instance form structure", httpMethod="GET")
    public Result<String> getDatasourceInstanceFormStructure(@ApiParam(value="jobCode", required=false) @RequestParam(required=false, value="jobCode") Long jobId, @ApiParam(value="connector type", required=true) @RequestParam(required=true, value="connectorType") String connectorType, @ApiParam(value="connector name", required=false) @RequestParam(required=false, value="connectorName") String connectorName, @ApiParam(value="dataSource instanceId", required=false) @RequestParam(required=false, value="dataSourceInstanceId") Long dataSourceInstanceId) {
        if (PluginType.TRANSFORM.getType().equals(connectorType)) {
            return Result.success(JsonUtils.toJsonString((Object)this.connectorService.getTransformFormStructure(connectorType, connectorName)));
        }
        return Result.success(JsonUtils.toJsonString((Object)this.connectorService.getDatasourceFormStructure(jobId, dataSourceInstanceId, connectorType)));
    }
}

