/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.controller.BaseController;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.apache.seatunnel.app.dal.entity.User;
import org.apache.seatunnel.app.domain.dto.datasource.DatabaseTableFields;
import org.apache.seatunnel.app.domain.dto.datasource.DatabaseTables;
import org.apache.seatunnel.app.domain.dto.datasource.TableInfo;
import org.apache.seatunnel.app.domain.request.datasource.DatasourceCheckReq;
import org.apache.seatunnel.app.domain.request.datasource.DatasourceReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.datasource.DatasourceDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.DatasourceRes;
import org.apache.seatunnel.app.service.IDatasourceService;
import org.apache.seatunnel.app.utils.CartesianProductUtils;
import org.apache.seatunnel.app.utils.PropertyUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginInfo;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/seatunnel/api/v1/datasource"})
public class SeatunnelDatasourceController
extends BaseController {
    @Autowired
    private IDatasourceService datasourceService;
    @Resource(name="userDaoImpl")
    private IUserDao userMapper;
    private static final String DEFAULT_PLUGIN_VERSION = "1.0.0";
    private static final String WS_SOURCE = "WS";
    private static final List<String> wsSupportDatasources = PropertyUtils.getList("ws.support.datasources", ",");

    @ApiOperation(value="create datasource", notes="create datasource")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasourceName", value="datasource name", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="pluginName", value="plugin name", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="description", value="description", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="datasourceConfig", value="datasource config", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/create"})
    Result<String> createDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestBody DatasourceReq req) {
        String datasourceConfig = req.getDatasourceConfig();
        Map stringStringMap = JsonUtils.toMap((String)datasourceConfig);
        return Result.success(this.datasourceService.createDatasource(loginUser.getId(), req.getDatasourceName(), req.getPluginName(), DEFAULT_PLUGIN_VERSION, req.getDescription(), stringStringMap));
    }

    @ApiOperation(value="test datasource connection", notes="test datasource connection")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pluginName", value="plugin name", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="datasourceConfig", value="datasource config", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/check/connect"})
    Result<Boolean> testConnect(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestBody DatasourceCheckReq req) {
        return Result.success(this.datasourceService.testDatasourceConnectionAble(loginUser.getId(), req.getPluginName(), DEFAULT_PLUGIN_VERSION, req.getDatasourceConfig()));
    }

    @ApiOperation(value="update datasource", notes="update datasource")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasourceName", value="datasource name", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="description", value="description", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="datasourceConfig", value="datasource config", required=false, dataType="String", paramType="query")})
    @PutMapping(value={"/{id}"})
    Result<Boolean> updateDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") String id, @RequestBody DatasourceReq req) {
        Map stringStringMap = JsonUtils.toMap((String)req.getDatasourceConfig());
        Long datasourceId = Long.parseLong(id);
        return Result.success(this.datasourceService.updateDatasource(loginUser.getId(), datasourceId, req.getDatasourceName(), req.getDescription(), stringStringMap));
    }

    @ApiOperation(value="delete datasource by id", notes="delete datasource by id")
    @DeleteMapping(value={"/{id}"})
    Result<Boolean> deleteDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") String id) {
        Long datasourceId = Long.parseLong(id);
        return Result.success(this.datasourceService.deleteDatasource(loginUser.getId(), datasourceId));
    }

    @ApiOperation(value="get datasource detail", notes="get datasource detail")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="user id", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/{id}"})
    Result<DatasourceDetailRes> getDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") String id) {
        return Result.success(this.datasourceService.queryDatasourceDetailById(loginUser.getId(), id));
    }

    @ApiOperation(value="get datasource list", notes="get datasource list")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="search value", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="pluginName", value="plugin name", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="pageNo", value="page no", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="page size", required=false, dataType="Integer", paramType="query")})
    @GetMapping(value={"/list"})
    Result<PageInfo<DatasourceRes>> getDatasourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal") String searchVal, @RequestParam(value="pluginName") String pluginName, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        PageInfo<DatasourceRes> datasourceResPageInfo = this.datasourceService.queryDatasourceList(loginUser.getId(), searchVal, pluginName, pageNo, pageSize);
        if (CollectionUtils.isNotEmpty(datasourceResPageInfo.getData())) {
            Map<Integer, String> userIdNameMap = this.userIdNameMap();
            datasourceResPageInfo.getData().forEach(datasourceRes -> {
                Map<String, String> datasourceConfig = datasourceRes.getDatasourceConfig();
                Optional.ofNullable(MapUtils.getString(datasourceConfig, (Object)"password")).ifPresent(password -> datasourceConfig.put("password", CartesianProductUtils.maskPassword(password)));
                datasourceRes.setDatasourceConfig(datasourceConfig);
                datasourceRes.setCreateUserName(userIdNameMap.getOrDefault(datasourceRes.getCreateUserId(), ""));
                datasourceRes.setUpdateUserName(userIdNameMap.getOrDefault(datasourceRes.getUpdateUserId(), ""));
            });
        }
        return Result.success(datasourceResPageInfo);
    }

    @ApiOperation(value="get datasource type list", notes="get datasource type list")
    @ApiImplicitParams(value={@ApiImplicitParam(name="showVirtualDataSource", value="show virtual datasource", required=false, defaultValue="true", dataType="Boolean", paramType="query")})
    @GetMapping(value={"/support-datasources"})
    Result<Map<Integer, List<DataSourcePluginInfo>>> getSupportDatasources(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="showVirtualDataSource") Boolean showVirtualDataSource, @RequestParam(value="source", required=false) String source) {
        Map<Integer, List<DataSourcePluginInfo>> allDatasources = this.datasourceService.queryAllDatasourcesGroupByType(showVirtualDataSource);
        if (StringUtils.isEmpty((CharSequence)source) || source.equals(WS_SOURCE)) {
            allDatasources.forEach((k, typeList) -> {
                typeList = typeList.stream().filter(plugin -> wsSupportDatasources.contains(plugin.getName())).collect(Collectors.toList());
                allDatasources.put((Integer)k, (List<DataSourcePluginInfo>)typeList);
            });
        }
        return Result.success(allDatasources);
    }

    @GetMapping(value={"/dynamic-form"})
    Result<String> getDynamicForm(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pluginName") String pluginName) {
        return Result.success(this.datasourceService.getDynamicForm(pluginName));
    }

    @GetMapping(value={"/databases"})
    Result<List<String>> getDatabases(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="datasourceName") String datasourceName) {
        return Result.success(this.datasourceService.queryDatabaseByDatasourceName(datasourceName));
    }

    @GetMapping(value={"/tables"})
    Result<List<String>> getTableNames(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="datasourceName") String datasourceName, @RequestParam(value="databaseName") String databaseName, @RequestParam(value="filterName") String filterName, @RequestParam(value="size") Integer size) {
        return Result.success(this.datasourceService.queryTableNames(datasourceName, databaseName, filterName, size));
    }

    @GetMapping(value={"/schema"})
    Result<List<TableField>> getTableFields(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="datasourceId") String datasourceId, @RequestParam(value="databaseName", required=false) String databaseName, @RequestParam(value="tableName") String tableName) {
        DatasourceDetailRes res = this.datasourceService.queryDatasourceDetailById(datasourceId);
        if (StringUtils.isEmpty((CharSequence)databaseName)) {
            throw new SeatunnelException(SeatunnelErrorEnum.INVALID_DATASOURCE, new Object[]{res.getDatasourceName()});
        }
        List<TableField> tableFields = this.datasourceService.queryTableSchema(res.getDatasourceName(), databaseName, tableName);
        return Result.success(tableFields);
    }

    @PostMapping(value={"/schemas"})
    Result<List<DatabaseTableFields>> getMultiTableFields(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="datasourceId") String datasourceId, @RequestBody List<DatabaseTables> tableNames) {
        DatasourceDetailRes res = this.datasourceService.queryDatasourceDetailById(datasourceId);
        ArrayList tableFields = new ArrayList();
        tableNames.forEach(database -> {
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            database.getTables().forEach(tableName -> {
                List<TableField> tableField = this.datasourceService.queryTableSchema(res.getDatasourceName(), database.getDatabase(), (String)tableName);
                tableInfos.add(new TableInfo((String)tableName, tableField));
            });
            tableFields.add(new DatabaseTableFields(database.getDatabase(), tableInfos));
        });
        return Result.success(tableFields);
    }

    @GetMapping(value={"/all-tables"})
    Result<List<DatabaseTables>> getTables(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="datasourceId") String datasourceId) {
        DatasourceDetailRes res = this.datasourceService.queryDatasourceDetailById(datasourceId);
        ArrayList tables = new ArrayList();
        List<String> databases = this.datasourceService.queryDatabaseByDatasourceName(res.getDatasourceName());
        databases.forEach(database -> tables.add(new DatabaseTables((String)database, this.datasourceService.queryTableNames(res.getDatasourceName(), (String)database))));
        return Result.success(tables);
    }

    public Map<Integer, String> userIdNameMap() {
        return this.userMapper.queryEnabledUsers().stream().collect(Collectors.toMap(User::getId, User::getUsername));
    }
}

