/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.ScriptStatusEnum;
import org.apache.seatunnel.app.dal.dao.IScriptDao;
import org.apache.seatunnel.app.dal.entity.Script;
import org.apache.seatunnel.app.dal.mapper.ScriptMapper;
import org.apache.seatunnel.app.domain.dto.script.CheckScriptDuplicateDto;
import org.apache.seatunnel.app.domain.dto.script.CreateScriptDto;
import org.apache.seatunnel.app.domain.dto.script.ListScriptsDto;
import org.apache.seatunnel.app.domain.dto.script.UpdateScriptContentDto;
import org.apache.seatunnel.server.common.PageData;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.springframework.stereotype.Repository;

@Repository
public class ScriptDaoImpl
implements IScriptDao {
    @Resource
    private ScriptMapper scriptMapper;

    @Override
    public void checkScriptDuplicate(CheckScriptDuplicateDto dto) {
        Script script = this.scriptMapper.selectByNameAndCreatorAndStatusNotEq(dto.getName(), dto.getCreatorId(), (byte)ScriptStatusEnum.DELETED.getCode());
        Preconditions.checkState((boolean)Objects.isNull(script), (Object)String.format(SeatunnelErrorEnum.SCRIPT_ALREADY_EXIST.getTemplate(), dto.getName()));
    }

    @Override
    public int createScript(CreateScriptDto dto) {
        Script script = new Script();
        script.setName(dto.getName());
        script.setType(dto.getType());
        script.setStatus(dto.getStatus());
        script.setCreatorId(dto.getCreatorId());
        script.setMenderId(dto.getMenderId());
        script.setContent(dto.getContent());
        this.scriptMapper.insert(script);
        return script.getId();
    }

    @Override
    public Script getScript(Integer id) {
        return this.scriptMapper.selectByPrimaryKey(id);
    }

    @Override
    public void updateScriptContent(UpdateScriptContentDto dto) {
        this.scriptMapper.updateContentByPrimaryKey(dto.getId(), dto.getContent(), dto.getContentMd5(), dto.getMenderId());
    }

    @Override
    public void deleteScript(int id) {
        this.scriptMapper.updateStatus(id, (byte)ScriptStatusEnum.DELETED.getCode());
    }

    @Override
    public PageData<Script> list(ListScriptsDto dto, Integer pageNo, Integer pageSize) {
        Script script = new Script();
        script.setName(dto.getName());
        List<Script> scripts = this.scriptMapper.selectBySelectiveAndPage(script, pageNo * pageSize, pageSize);
        int count = this.scriptMapper.countBySelectiveAndPage(script);
        return new PageData(count, scripts);
    }

    @Override
    public void updateStatus(Script script) {
        this.scriptMapper.updateStatus(script.getId(), script.getStatus());
    }
}

