/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.factory.DataTypeConvertorFactory;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.app.bean.connector.ConnectorCache;
import org.apache.seatunnel.app.bean.engine.EngineDataType;
import org.apache.seatunnel.app.config.ConnectorDataSourceMapperConfig;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.TableSchemaReq;
import org.apache.seatunnel.app.domain.response.job.TableSchemaRes;
import org.apache.seatunnel.app.service.IDatasourceService;
import org.apache.seatunnel.app.service.ITableSchemaService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TableSchemaServiceImpl
extends SeatunnelBaseServiceImpl
implements ITableSchemaService {
    private static final Logger log = LoggerFactory.getLogger(TableSchemaServiceImpl.class);
    @Resource
    private ConnectorCache connectorCache;
    @Resource
    private ConnectorDataSourceMapperConfig connectorDataSourceMapperConfig;
    @Resource(name="datasourceServiceImpl")
    private IDatasourceService dataSourceService;
    private final DataTypeConvertorFactory factory;

    public TableSchemaServiceImpl() throws IOException {
        Common.setStarter((boolean)true);
        Set pluginIdentifiers = SeaTunnelSinkPluginDiscovery.getAllSupportedPlugins((PluginType)PluginType.SINK).keySet();
        ArrayList pluginIdentifiersList = new ArrayList();
        pluginIdentifiersList.addAll(pluginIdentifiers);
        List pluginJarPaths = new SeaTunnelSinkPluginDiscovery().getPluginJarPaths(pluginIdentifiersList);
        if (!pluginJarPaths.isEmpty()) {
            pluginJarPaths.addAll(FileUtils.searchJarFiles((Path)Common.pluginRootDir()));
            this.factory = new DataTypeConvertorFactory((ClassLoader)new URLClassLoader(pluginJarPaths.toArray(new URL[0])));
        } else {
            this.factory = new DataTypeConvertorFactory();
        }
    }

    @Override
    public TableSchemaRes getSeaTunnelSchema(String pluginName, TableSchemaReq tableSchemaReq) {
        DataTypeConvertor convertor;
        this.funcPermissionCheck("project:seatunnel-task:table-schema", 0);
        pluginName = pluginName.toUpperCase();
        if (pluginName.endsWith("-CDC")) {
            pluginName = pluginName.replace("-CDC", "");
        } else if (pluginName.startsWith("JDBC_")) {
            pluginName = pluginName.replace("JDBC_", "");
        } else if (pluginName.startsWith("JDBC-")) {
            pluginName = pluginName.replace("JDBC-", "");
        }
        try {
            convertor = this.factory.getDataTypeConvertor(pluginName);
        }
        catch (Exception e) {
            convertor = new EngineDataType.SeaTunnelDataTypeConvertor();
            log.warn("The convertor of plugin: {} is not exist, will use EngineDataType.SeaTunnelDataTypeConvertor", (Object)pluginName);
        }
        for (TableField field : tableSchemaReq.getFields()) {
            SeaTunnelDataType dataType = convertor.toSeaTunnelType(field.getName(), field.getType());
            field.setType(dataType.toString());
        }
        TableSchemaRes res = new TableSchemaRes();
        res.setFields(tableSchemaReq.getFields());
        return res;
    }

    @Override
    public void getAddSeaTunnelSchema(List<TableField> tableFields, String pluginName) {
        DataTypeConvertor convertor;
        if ((pluginName = pluginName.toUpperCase()).endsWith("-CDC")) {
            pluginName = pluginName.replace("-CDC", "");
        } else if (pluginName.startsWith("JDBC_")) {
            pluginName = pluginName.replace("JDBC_", "");
        } else if (pluginName.startsWith("JDBC-")) {
            pluginName = pluginName.replace("JDBC-", "");
        }
        try {
            convertor = this.factory.getDataTypeConvertor(pluginName);
        }
        catch (Exception e) {
            convertor = new EngineDataType.SeaTunnelDataTypeConvertor();
            log.warn("The convertor of plugin: {} is not exist, will use EngineDataType.SeaTunnelDataTypeConvertor", (Object)pluginName);
        }
        for (TableField field : tableFields) {
            try {
                SeaTunnelDataType dataType = convertor.toSeaTunnelType(field.getName(), field.getType());
                field.setUnSupport(Boolean.valueOf(false));
                field.setOutputDataType(dataType.toString());
            }
            catch (Exception exception) {
                field.setUnSupport(Boolean.valueOf(true));
                log.warn("Database {} , field {} is unSupport", new Object[]{pluginName, field.getType(), exception});
            }
        }
    }

    @Override
    public boolean getColumnProjection(String pluginName) {
        this.funcPermissionCheck("project:seatunnel-task:column-projection", 0);
        String connector = this.connectorDataSourceMapperConfig.findConnectorForDatasourceName(pluginName).orElseThrow(() -> new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"Unsupported Data Source Name"}));
        return this.connectorCache.getConnectorFeature(PluginIdentifier.of((String)"seatunnel", (String)PluginType.SOURCE.getType(), (String)connector)).isSupportColumnProjection();
    }

    @Override
    public DataSourceOption checkDatabaseAndTable(String datasourceId, DataSourceOption dataSourceOption) {
        ArrayList<String> notExistDatabases = new ArrayList<String>();
        String datasourceName = this.dataSourceService.queryDatasourceDetailById(datasourceId).getDatasourceName();
        if (dataSourceOption.getDatabases() != null) {
            List<String> databases = this.dataSourceService.queryDatabaseByDatasourceName(datasourceName);
            notExistDatabases.addAll(dataSourceOption.getDatabases().stream().filter(database -> !databases.contains(database)).collect(Collectors.toList()));
        }
        HashMap tables = new HashMap();
        if (dataSourceOption.getTables() != null) {
            ArrayList<String> notExistTables = new ArrayList<String>();
            dataSourceOption.getTables().forEach(tableStr -> {
                String database = dataSourceOption.getDatabases().get(0);
                String table = tableStr;
                if (!tables.containsKey(database)) {
                    if (notExistDatabases.contains(database)) {
                        notExistTables.add((String)tableStr);
                        return;
                    }
                    tables.put(database, new HashSet<String>(this.dataSourceService.queryTableNames(datasourceName, database)));
                }
                if (!((Set)tables.get(database)).contains(table)) {
                    notExistTables.add((String)tableStr);
                }
            });
            return new DataSourceOption(notExistDatabases, notExistTables);
        }
        return new DataSourceOption(notExistDatabases, new ArrayList<String>());
    }
}

