/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seatunnel.app.dal.entity.JobTask;
import org.apache.seatunnel.app.domain.request.job.JobExecParam;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;

public class JobUtils {
    private static final int ERROR_MESSAGE_MAX_LENGTH = 4096;
    private static final Pattern placeholderPattern = Pattern.compile("(\\\\{0,2})\\$\\{(\\w+)(?::(.*?))?\\}");

    public static String getJobInstanceErrorMessage(String message) {
        if (message == null) {
            return null;
        }
        return message.length() > 4096 ? message.substring(0, 4096) : message;
    }

    public static void updateDataSource(JobExecParam jobExecParam, List<JobTask> tasks) {
        if (jobExecParam == null || jobExecParam.getDatasource() == null) {
            return;
        }
        jobExecParam.getDatasource().forEach((taskName, datasourceId) -> tasks.stream().filter(task -> task.getName().equals(taskName)).findFirst().ifPresent(task -> task.setDataSourceId(Long.parseLong(datasourceId))));
    }

    public static boolean isJobEndStatus(JobStatus jobStatus) {
        return JobStatus.FINISHED == jobStatus || JobStatus.CANCELED == jobStatus || JobStatus.FAILED == jobStatus;
    }

    public static String replaceJobConfigPlaceholders(String jobConfigString, JobExecParam jobExecParam) {
        Map placeholderValues = jobExecParam != null && jobExecParam.getPlaceholderValues() != null ? jobExecParam.getPlaceholderValues() : Collections.emptyMap();
        Matcher matcher = placeholderPattern.matcher(jobConfigString);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String escapeCharacter = matcher.group(1);
            String placeholderName = matcher.group(2);
            if (escapeCharacter != null && !escapeCharacter.isEmpty()) {
                String withoutEscape = matcher.group().replace("\\\\${", "${").replace("\\${", "${");
                matcher.appendReplacement(result, Matcher.quoteReplacement(withoutEscape));
                continue;
            }
            String replacement = placeholderValues.getOrDefault(placeholderName, matcher.group(3));
            if (replacement == null) {
                throw new SeatunnelException(SeatunnelErrorEnum.JOB_NO_VALUE_FOUND_FOR_PLACEHOLDER, new Object[]{placeholderName});
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

