/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel.llm;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactoryContext;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;
import org.apache.seatunnel.transform.nlpmodel.ModelProvider;
import org.apache.seatunnel.transform.nlpmodel.ModelTransformConfig;
import org.apache.seatunnel.transform.nlpmodel.llm.LLMTransform;
import org.apache.seatunnel.transform.nlpmodel.llm.LLMTransformConfig;

@AutoService(value={Factory.class})
public class LLMTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "LLM";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{LLMTransformConfig.MODEL_PROVIDER, LLMTransformConfig.MODEL, LLMTransformConfig.PROMPT}).optional(new Option[]{LLMTransformConfig.API_PATH, LLMTransformConfig.OUTPUT_DATA_TYPE, LLMTransformConfig.PROCESS_BATCH_SIZE}).conditional(LLMTransformConfig.MODEL_PROVIDER, (List)Lists.newArrayList((Object[])new ModelProvider[]{ModelProvider.OPENAI, ModelProvider.DOUBAO, ModelProvider.MICROSOFT}), new Option[]{LLMTransformConfig.API_KEY}).conditional(LLMTransformConfig.MODEL_PROVIDER, (Object)ModelProvider.QIANFAN, new Option[]{LLMTransformConfig.API_KEY, LLMTransformConfig.SECRET_KEY, LLMTransformConfig.OAUTH_PATH}).conditional(LLMTransformConfig.MODEL_PROVIDER, (Object)ModelProvider.CUSTOM, new Option[]{ModelTransformConfig.CustomRequestConfig.CUSTOM_CONFIG}).build();
    }

    public TableTransform createTransform(TableTransformFactoryContext context) {
        CatalogTable catalogTable = (CatalogTable)context.getCatalogTables().get(0);
        return () -> new LLMTransform(context.getOptions(), catalogTable);
    }
}

