/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink.multitablesink;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkCommonOptions;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableAggregatedCommitInfo;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableCommitInfo;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableSinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableSinkCommitter;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableSinkWriter;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableState;
import org.apache.seatunnel.api.sink.multitablesink.SinkContextProxy;
import org.apache.seatunnel.api.sink.multitablesink.SinkIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.factory.MultiTableFactoryContext;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;

public class MultiTableSink
implements SeaTunnelSink<SeaTunnelRow, MultiTableState, MultiTableCommitInfo, MultiTableAggregatedCommitInfo> {
    private final Map<String, SeaTunnelSink> sinks;
    private final int replicaNum;

    public MultiTableSink(MultiTableFactoryContext context) {
        this.sinks = context.getSinks();
        this.replicaNum = context.getOptions().get(SinkCommonOptions.MULTI_TABLE_SINK_REPLICA);
    }

    @Override
    public String getPluginName() {
        return "MultiTableSink";
    }

    @Override
    public SinkWriter<SeaTunnelRow, MultiTableCommitInfo, MultiTableState> createWriter(SinkWriter.Context context) throws IOException {
        HashMap writers = new HashMap();
        HashMap<SinkIdentifier, SinkWriter.Context> sinkWritersContext = new HashMap<SinkIdentifier, SinkWriter.Context>();
        for (int i = 0; i < this.replicaNum; ++i) {
            for (String tableIdentifier : this.sinks.keySet()) {
                SeaTunnelSink sink = this.sinks.get(tableIdentifier);
                int index = context.getIndexOfSubtask() * this.replicaNum + i;
                writers.put(SinkIdentifier.of(tableIdentifier, index), sink.createWriter(new SinkContextProxy(index, this.replicaNum, context)));
                sinkWritersContext.put(SinkIdentifier.of(tableIdentifier, index), context);
            }
        }
        return new MultiTableSinkWriter(writers, this.replicaNum, sinkWritersContext);
    }

    @Override
    public SinkWriter<SeaTunnelRow, MultiTableCommitInfo, MultiTableState> restoreWriter(SinkWriter.Context context, List<MultiTableState> states) throws IOException {
        HashMap writers = new HashMap();
        HashMap<SinkIdentifier, SinkWriter.Context> sinkWritersContext = new HashMap<SinkIdentifier, SinkWriter.Context>();
        for (int i = 0; i < this.replicaNum; ++i) {
            for (String tableIdentifier : this.sinks.keySet()) {
                SeaTunnelSink sink = this.sinks.get(tableIdentifier);
                int index = context.getIndexOfSubtask() * this.replicaNum + i;
                SinkIdentifier sinkIdentifier = SinkIdentifier.of(tableIdentifier, index);
                List state = states.stream().map(multiTableState -> multiTableState.getStates().get(sinkIdentifier)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                if (state.isEmpty()) {
                    writers.put(sinkIdentifier, sink.createWriter(new SinkContextProxy(index, this.replicaNum, context)));
                } else {
                    writers.put(sinkIdentifier, sink.restoreWriter(new SinkContextProxy(index, this.replicaNum, context), state));
                }
                sinkWritersContext.put(SinkIdentifier.of(tableIdentifier, index), context);
            }
        }
        return new MultiTableSinkWriter(writers, this.replicaNum, sinkWritersContext);
    }

    @Override
    public Optional<Serializer<MultiTableState>> getWriterStateSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    @Override
    public Optional<SinkCommitter<MultiTableCommitInfo>> createCommitter() throws IOException {
        HashMap committers = new HashMap();
        for (String tableIdentifier : this.sinks.keySet()) {
            SeaTunnelSink sink = this.sinks.get(tableIdentifier);
            sink.createCommitter().ifPresent(committer -> committers.put(tableIdentifier, (SinkCommitter)committer));
        }
        if (committers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MultiTableSinkCommitter(committers));
    }

    @Override
    public Optional<Serializer<MultiTableCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    @Override
    public Optional<SinkAggregatedCommitter<MultiTableCommitInfo, MultiTableAggregatedCommitInfo>> createAggregatedCommitter() throws IOException {
        HashMap aggCommitters = new HashMap();
        for (String tableIdentifier : this.sinks.keySet()) {
            SeaTunnelSink sink = this.sinks.get(tableIdentifier);
            Optional sinkOptional = sink.createAggregatedCommitter();
            sinkOptional.ifPresent(sinkAggregatedCommitter -> aggCommitters.put(tableIdentifier, (SinkAggregatedCommitter<?, ?>)sinkAggregatedCommitter));
        }
        if (aggCommitters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MultiTableSinkAggregatedCommitter(aggCommitters));
    }

    public List<TablePath> getSinkTables() {
        return this.sinks.keySet().stream().map(TablePath::of).collect(Collectors.toList());
    }

    @Override
    public Optional<Serializer<MultiTableAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    @Override
    public void setJobContext(JobContext jobContext) {
        this.sinks.values().forEach(sink -> sink.setJobContext(jobContext));
    }

    public Map<String, SeaTunnelSink> getSinks() {
        return this.sinks;
    }
}

