/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.seatunnel.api.tracing.MDCCallable;
import org.apache.seatunnel.api.tracing.MDCContext;
import org.apache.seatunnel.api.tracing.MDCExecutor;
import org.apache.seatunnel.api.tracing.MDCExecutorService;
import org.apache.seatunnel.api.tracing.MDCRunnable;
import org.apache.seatunnel.api.tracing.MDCScheduledExecutorService;

public class MDCTracer {
    public static MDCRunnable tracing(Runnable delegate) {
        return MDCTracer.tracing(MDCContext.current(), delegate);
    }

    public static MDCRunnable tracing(Long jobId, Runnable delegate) {
        return MDCTracer.tracing(MDCContext.of(jobId), delegate);
    }

    public static MDCRunnable tracing(MDCContext context, Runnable delegate) {
        if (delegate instanceof MDCRunnable) {
            throw new IllegalArgumentException("Already an MDCRunnable");
        }
        return new MDCRunnable(context, delegate);
    }

    public static <V> MDCCallable<V> tracing(Callable<V> delegate) {
        return MDCTracer.tracing(MDCContext.current(), delegate);
    }

    public static <V> MDCCallable<V> tracing(Long jobId, Callable<V> delegate) {
        return MDCTracer.tracing(MDCContext.of(jobId), delegate);
    }

    public static <V> MDCCallable<V> tracing(MDCContext context, Callable<V> delegate) {
        if (delegate instanceof MDCCallable) {
            throw new IllegalArgumentException("Already an MDCCallable");
        }
        return new MDCCallable<V>(context, delegate);
    }

    public static MDCExecutor tracing(Executor delegate) {
        return MDCTracer.tracing(MDCContext.current(), delegate);
    }

    public static MDCExecutor tracing(Long jobId, Executor delegate) {
        return MDCTracer.tracing(MDCContext.of(jobId), delegate);
    }

    public static MDCExecutor tracing(MDCContext context, Executor delegate) {
        if (delegate instanceof MDCExecutor) {
            throw new IllegalArgumentException("Already an MDCExecutor");
        }
        return new MDCExecutor(context, delegate);
    }

    public static MDCExecutorService tracing(ExecutorService delegate) {
        return MDCTracer.tracing(MDCContext.current(), delegate);
    }

    public static MDCExecutorService tracing(Long jobId, ExecutorService delegate) {
        return MDCTracer.tracing(MDCContext.of(jobId), delegate);
    }

    public static MDCExecutorService tracing(MDCContext context, ExecutorService delegate) {
        if (delegate instanceof MDCExecutor) {
            throw new IllegalArgumentException("Already an MDCExecutor");
        }
        return new MDCExecutorService(context, delegate);
    }

    public static MDCScheduledExecutorService tracing(ScheduledExecutorService delegate) {
        return MDCTracer.tracing(MDCContext.current(), delegate);
    }

    public static MDCScheduledExecutorService tracing(Long jobId, ScheduledExecutorService delegate) {
        return MDCTracer.tracing(MDCContext.of(jobId), delegate);
    }

    public static MDCScheduledExecutorService tracing(MDCContext context, ScheduledExecutorService delegate) {
        if (delegate instanceof MDCExecutor) {
            throw new IllegalArgumentException("Already an MDCExecutor");
        }
        return new MDCScheduledExecutorService(context, delegate);
    }
}

