/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.converter;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.distsql.handler.converter.MaskConvertDistSQLConstants;

public final class MaskRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<MaskRuleConfiguration> {
    public String convert(MaskRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().isEmpty() ? "" : "CREATE MASK RULE" + this.convertMaskTables(ruleConfig) + ";";
    }

    private String convertMaskTables(MaskRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().stream().map(each -> this.convertMaskTable((MaskTableRuleConfiguration)each, ruleConfig.getMaskAlgorithms())).collect(Collectors.joining("," + System.lineSeparator()));
    }

    private String convertMaskTable(MaskTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        return String.format(MaskConvertDistSQLConstants.MASK_TABLE, tableRuleConfig.getName(), this.convertMaskColumns(tableRuleConfig.getColumns(), maskAlgorithms));
    }

    private String convertMaskColumns(Collection<MaskColumnRuleConfiguration> columnRuleConfigs, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        return columnRuleConfigs.stream().map(each -> this.convertMaskColumn((MaskColumnRuleConfiguration)each, maskAlgorithms)).collect(Collectors.joining("," + System.lineSeparator()));
    }

    private String convertMaskColumn(MaskColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        return String.format("(NAME=%s, %s)", columnRuleConfig.getLogicColumn(), AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)maskAlgorithms.get(columnRuleConfig.getMaskAlgorithm())));
    }

    public Class<MaskRuleConfiguration> getType() {
        return MaskRuleConfiguration.class;
    }
}

