/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.lifecycle.DecorateSQLRouter;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.readwritesplitting.route.ReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class ReadwriteSplittingSQLRouter
implements DecorateSQLRouter<ReadwriteSplittingRule> {
    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, ReadwriteSplittingRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        LinkedList toBeRemoved = new LinkedList();
        LinkedList toBeAdded = new LinkedList();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            String logicDataSourceName = each.getDataSourceMapper().getActualName();
            rule.findDataSourceGroupRule(logicDataSourceName).ifPresent(optional -> {
                toBeRemoved.add(each);
                String actualDataSourceName = new ReadwriteSplittingDataSourceRouter((ReadwriteSplittingDataSourceGroupRule)optional, queryContext.getConnectionContext()).route(queryContext.getSqlStatementContext(), queryContext.getHintValueContext());
                toBeAdded.add(new RouteUnit(new RouteMapper(logicDataSourceName, actualDataSourceName), each.getTableMappers()));
            });
        }
        routeContext.getRouteUnits().removeAll(toBeRemoved);
        routeContext.getRouteUnits().addAll(toBeAdded);
    }

    public SQLRouter.Type getType() {
        return SQLRouter.Type.DATA_SOURCE;
    }

    public int getOrder() {
        return 45;
    }

    public Class<ReadwriteSplittingRule> getTypeClass() {
        return ReadwriteSplittingRule.class;
    }
}

