/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.type;

import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLAnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLEmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLLoadStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLResetParameterStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLSetStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLShowStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLVacuumStatement;

public final class PostgreSQLDALStatementVisitor
extends PostgreSQLStatementVisitor
implements DALStatementVisitor {
    @Override
    public ASTNode visitShow(PostgreSQLStatementParser.ShowContext ctx) {
        if (null != ctx.varName()) {
            return new PostgreSQLShowStatement(ctx.varName().getText());
        }
        if (null != ctx.ZONE()) {
            return new PostgreSQLShowStatement("timezone");
        }
        if (null != ctx.ISOLATION()) {
            return new PostgreSQLShowStatement("transaction_isolation");
        }
        if (null != ctx.AUTHORIZATION()) {
            return new PostgreSQLShowStatement("session_authorization");
        }
        return new PostgreSQLShowStatement("ALL");
    }

    @Override
    public ASTNode visitSet(PostgreSQLStatementParser.SetContext ctx) {
        PostgreSQLSetStatement result = new PostgreSQLSetStatement();
        LinkedList<VariableAssignSegment> variableAssigns = new LinkedList<VariableAssignSegment>();
        if (null != ctx.configurationParameterClause()) {
            VariableAssignSegment variableAssignSegment = (VariableAssignSegment)this.visit((ParseTree)ctx.configurationParameterClause());
            if (null != ctx.runtimeScope()) {
                variableAssignSegment.getVariable().setScope(ctx.runtimeScope().getText());
            }
            variableAssigns.add(variableAssignSegment);
        }
        if (null != ctx.encoding()) {
            VariableSegment variable = new VariableSegment(ctx.NAMES().getSymbol().getStartIndex(), ctx.NAMES().getSymbol().getStopIndex(), "client_encoding");
            VariableAssignSegment variableAssign = new VariableAssignSegment(ctx.encoding().start.getStartIndex(), ctx.encoding().stop.getStopIndex(), variable, ctx.encoding().getText());
            variableAssigns.add(variableAssign);
        }
        result.getVariableAssigns().addAll(variableAssigns);
        return result;
    }

    @Override
    public ASTNode visitConfigurationParameterClause(PostgreSQLStatementParser.ConfigurationParameterClauseContext ctx) {
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new VariableSegment(ctx.varName().start.getStartIndex(), ctx.varName().stop.getStopIndex(), ctx.varName().getText()), this.getAssignValue(ctx));
    }

    private String getAssignValue(PostgreSQLStatementParser.ConfigurationParameterClauseContext ctx) {
        if (null != ctx.varList()) {
            return ctx.varList().getText();
        }
        if (null != ctx.DEFAULT()) {
            return ctx.DEFAULT().getText();
        }
        return null;
    }

    @Override
    public ASTNode visitResetParameter(PostgreSQLStatementParser.ResetParameterContext ctx) {
        return new PostgreSQLResetParameterStatement(null != ctx.ALL() ? "ALL" : ctx.identifier().getText());
    }

    @Override
    public ASTNode visitAnalyzeTable(PostgreSQLStatementParser.AnalyzeTableContext ctx) {
        PostgreSQLAnalyzeTableStatement result = new PostgreSQLAnalyzeTableStatement();
        if (null != ctx.vacuumRelationList()) {
            result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.vacuumRelationList())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitVacuumRelationList(PostgreSQLStatementParser.VacuumRelationListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.VacuumRelationContext each : ctx.vacuumRelation()) {
            PostgreSQLStatementParser.ColIdContext colId = each.qualifiedName().colId();
            TableNameSegment tableName = new TableNameSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            result.getValue().add(new SimpleTableSegment(tableName));
        }
        return result;
    }

    @Override
    public ASTNode visitLoad(PostgreSQLStatementParser.LoadContext ctx) {
        return new PostgreSQLLoadStatement();
    }

    @Override
    public ASTNode visitVacuum(PostgreSQLStatementParser.VacuumContext ctx) {
        return new PostgreSQLVacuumStatement();
    }

    @Override
    public ASTNode visitExplain(PostgreSQLStatementParser.ExplainContext ctx) {
        PostgreSQLExplainStatement result = new PostgreSQLExplainStatement();
        result.setSqlStatement((SQLStatement)this.visit((ParseTree)ctx.explainableStmt()));
        return result;
    }

    @Override
    public ASTNode visitExplainableStmt(PostgreSQLStatementParser.ExplainableStmtContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.update()) {
            return (ASTNode)this.visit((ParseTree)ctx.update());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.declare()) {
            return (ASTNode)this.visit((ParseTree)ctx.declare());
        }
        if (null != ctx.executeStmt()) {
            return (ASTNode)this.visit((ParseTree)ctx.executeStmt());
        }
        if (null != ctx.createMaterializedView()) {
            return (ASTNode)this.visit((ParseTree)ctx.createMaterializedView());
        }
        return (ASTNode)this.visit((ParseTree)ctx.refreshMatViewStmt());
    }

    @Override
    public ASTNode visitEmptyStatement(PostgreSQLStatementParser.EmptyStatementContext ctx) {
        return new PostgreSQLEmptyStatement();
    }
}

