/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.type;

import java.util.Collection;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLAlterRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLAlterUserStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLCreateGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLCreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLDropRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLDropUserStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLGrantStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLReassignOwnedStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dcl.PostgreSQLRevokeStatement;

public final class PostgreSQLDCLStatementVisitor
extends PostgreSQLStatementVisitor
implements DCLStatementVisitor {
    @Override
    public ASTNode visitGrant(PostgreSQLStatementParser.GrantContext ctx) {
        PostgreSQLGrantStatement result = new PostgreSQLGrantStatement();
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(PostgreSQLStatementParser.RevokeContext ctx) {
        PostgreSQLRevokeStatement result = new PostgreSQLRevokeStatement();
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    private boolean containsTableSegment(PostgreSQLStatementParser.PrivilegeClauseContext ctx) {
        return null != ctx && null != ctx.onObjectClause() && null != ctx.onObjectClause().privilegeLevel() && null != ctx.onObjectClause().privilegeLevel().tableNames();
    }

    private Collection<SimpleTableSegment> getTableSegments(PostgreSQLStatementParser.PrivilegeClauseContext ctx) {
        return ((CollectionValue)this.visit((ParseTree)ctx.onObjectClause().privilegeLevel().tableNames())).getValue();
    }

    @Override
    public ASTNode visitCreateUser(PostgreSQLStatementParser.CreateUserContext ctx) {
        return new PostgreSQLCreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(PostgreSQLStatementParser.DropUserContext ctx) {
        return new PostgreSQLDropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(PostgreSQLStatementParser.AlterUserContext ctx) {
        return new PostgreSQLAlterUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(PostgreSQLStatementParser.CreateRoleContext ctx) {
        return new PostgreSQLCreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(PostgreSQLStatementParser.AlterRoleContext ctx) {
        return new PostgreSQLAlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(PostgreSQLStatementParser.DropRoleContext ctx) {
        return new PostgreSQLDropRoleStatement();
    }

    @Override
    public ASTNode visitReassignOwned(PostgreSQLStatementParser.ReassignOwnedContext ctx) {
        return new PostgreSQLReassignOwnedStatement();
    }

    @Override
    public ASTNode visitCreateGroup(PostgreSQLStatementParser.CreateGroupContext ctx) {
        return new PostgreSQLCreateGroupStatement();
    }
}

