/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.metadata.ComputeNodePath;

public final class ComputeNodeStateChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return ComputeNodePath.getRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        ComputeNodePath.findInstanceId((String)event.getKey()).ifPresent(optional -> this.handle(contextManager, event, (String)optional));
    }

    private void handle(ContextManager contextManager, DataChangedEvent event, String instanceId) {
        ComputeNodeInstanceContext computeNodeInstanceContext = contextManager.getComputeNodeInstanceContext();
        if (event.getKey().equals(ComputeNodePath.getStatePath((String)instanceId)) && DataChangedEvent.Type.DELETED != event.getType()) {
            computeNodeInstanceContext.updateStatus(instanceId, event.getValue());
        } else if (event.getKey().equals(ComputeNodePath.getLabelsPath((String)instanceId)) && DataChangedEvent.Type.DELETED != event.getType()) {
            computeNodeInstanceContext.updateLabels(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class));
        } else if (event.getKey().equals(ComputeNodePath.getWorkerIdPath((String)instanceId))) {
            computeNodeInstanceContext.updateWorkerId(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? null : Integer.valueOf(event.getValue()));
        }
    }
}

