/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.listener;

import java.util.Collection;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.type.DatabaseMetaDataChangedListener;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.type.GlobalMetaDataChangedListener;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class DataChangedEventListenerRegistry {
    private final ContextManager contextManager;
    private final ClusterPersistRepository repository;
    private final Collection<String> databaseNames;

    public DataChangedEventListenerRegistry(ContextManager contextManager, Collection<String> databaseNames) {
        this.contextManager = contextManager;
        this.repository = (ClusterPersistRepository)contextManager.getPersistServiceFacade().getRepository();
        this.databaseNames = databaseNames;
    }

    public void register() {
        this.databaseNames.forEach(this::registerDatabaseListeners);
        ShardingSphereServiceLoader.getServiceInstances(DataChangedEventHandler.class).forEach(this::registerGlobalHandlers);
    }

    private void registerDatabaseListeners(String databaseName) {
        this.repository.watch(DatabaseMetaDataNodePath.getDatabasePath((String)databaseName), (DataChangedEventListener)new DatabaseMetaDataChangedListener(this.contextManager));
    }

    private void registerGlobalHandlers(DataChangedEventHandler handler) {
        this.repository.watch(handler.getSubscribedKey(), (DataChangedEventListener)new GlobalMetaDataChangedListener(this.contextManager, handler));
    }
}

