/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.classbased;

import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.sharding.exception.algorithm.ShardingAlgorithmClassImplementationException;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ClassBasedShardingAlgorithmFactory {
    public static <T extends ShardingAlgorithm> T newInstance(String shardingAlgorithmClassName, Class<T> superShardingAlgorithmClass, Properties props) {
        Class<?> algorithmClass = Class.forName(shardingAlgorithmClassName);
        if (!superShardingAlgorithmClass.isAssignableFrom(algorithmClass)) {
            throw new ShardingAlgorithmClassImplementationException(shardingAlgorithmClassName, superShardingAlgorithmClass);
        }
        ShardingAlgorithm result = (ShardingAlgorithm)algorithmClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.init(ClassBasedShardingAlgorithmFactory.convertToStringTypedProperties(props));
        return (T)result;
    }

    private static Properties convertToStringTypedProperties(Properties props) {
        Properties result = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty(key.toString(), null == value ? null : value.toString())));
        return result;
    }

    @Generated
    private ClassBasedShardingAlgorithmFactory() {
    }
}

