/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.ddl.fetch;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.FetchStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.stream.StreamMergedResult;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.connection.cursor.FetchGroup;
import org.apache.shardingsphere.sharding.exception.connection.CursorNameNotFoundException;
import org.apache.shardingsphere.sharding.merge.ddl.fetch.FetchOrderByValueGroup;
import org.apache.shardingsphere.sharding.merge.dql.orderby.OrderByValue;
import org.apache.shardingsphere.sql.parser.statement.core.enums.DirectionType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.DirectionSegment;

public final class FetchStreamMergedResult
extends StreamMergedResult {
    private final Queue<OrderByValue> orderByValuesQueue;
    private final DirectionType directionType;
    private long fetchCount;
    private boolean isFirstNext;
    private boolean isExecutedAllDirection;

    public FetchStreamMergedResult(List<QueryResult> queryResults, FetchStatementContext fetchStatementContext, ShardingSphereSchema schema, ConnectionContext connectionContext) throws SQLException {
        this.orderByValuesQueue = new PriorityQueue<OrderByValue>(queryResults.size());
        this.directionType = fetchStatementContext.getSqlStatement().getDirection().map(DirectionSegment::getDirectionType).orElse(DirectionType.NEXT);
        this.fetchCount = fetchStatementContext.getSqlStatement().getDirection().flatMap(DirectionSegment::getCount).orElse(1L);
        SelectStatementContext selectStatementContext = fetchStatementContext.getCursorStatementContext().getSelectStatementContext();
        String cursorName = fetchStatementContext.getCursorName().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElseThrow(CursorNameNotFoundException::new);
        List<FetchOrderByValueGroup> fetchOrderByValueGroups = this.getFetchOrderByValueGroups(queryResults, selectStatementContext, schema, cursorName, connectionContext);
        this.addOrderedResultSetsToQueue(fetchOrderByValueGroups, queryResults);
        this.setMinResultSetRowCount(cursorName, connectionContext);
        this.handleExecutedAllDirections(connectionContext, cursorName);
        this.isFirstNext = true;
    }

    public boolean next() throws SQLException {
        if (this.isExecutedAllDirection) {
            return false;
        }
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            --this.fetchCount;
            return true;
        }
        OrderByValue firstOrderByValue = this.orderByValuesQueue.poll();
        if (firstOrderByValue.next()) {
            this.orderByValuesQueue.offer(firstOrderByValue);
        }
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.peek().getQueryResult());
        return DirectionType.isAllDirectionType((DirectionType)this.directionType) || this.fetchCount-- > 0L;
    }

    private List<FetchOrderByValueGroup> getFetchOrderByValueGroups(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, ShardingSphereSchema schema, String cursorName, ConnectionContext connectionContext) throws SQLException {
        long actualFetchCount = Math.max(this.fetchCount - connectionContext.getCursorContext().getMinGroupRowCounts().getOrDefault(cursorName, 0L), 0L);
        List fetchGroups = connectionContext.getCursorContext().getOrderByValueGroups().computeIfAbsent(cursorName, key -> this.createFetchOrderByValueGroups(queryResults.size()));
        ArrayList<FetchOrderByValueGroup> result = new ArrayList<FetchOrderByValueGroup>(fetchGroups.size());
        for (FetchGroup each2 : fetchGroups) {
            result.add((FetchOrderByValueGroup)each2);
        }
        result.forEach(each -> each.getOrderByValues().removeIf(this::isEmptyOrderByValue));
        if (0L == actualFetchCount && !DirectionType.isAllDirectionType((DirectionType)this.directionType)) {
            return result;
        }
        if (connectionContext.getCursorContext().getExecutedAllDirections().containsKey(cursorName)) {
            result.forEach(each -> each.getOrderByValues().clear());
            return result;
        }
        Collection items = selectStatementContext.getOrderByContext().getItems();
        int index = 0;
        for (QueryResult each3 : queryResults) {
            QueryResult queryResult = this.decorate(each3, selectStatementContext.getDatabaseType());
            OrderByValue orderByValue = new OrderByValue(queryResult, items, selectStatementContext, schema);
            if (orderByValue.next()) {
                ((FetchOrderByValueGroup)result.get(index)).getOrderByValues().add(orderByValue);
            }
            ++index;
        }
        return result;
    }

    private List<FetchGroup> createFetchOrderByValueGroups(int queryResultSize) {
        ArrayList<FetchGroup> result = new ArrayList<FetchGroup>(queryResultSize);
        for (int index = 0; index < queryResultSize; ++index) {
            result.add(new FetchOrderByValueGroup());
        }
        return result;
    }

    private boolean isEmptyOrderByValue(OrderByValue orderByValue) {
        return orderByValue.getQueryResult() instanceof JDBCMemoryQueryResult && 0L == ((JDBCMemoryQueryResult)orderByValue.getQueryResult()).getRowCount() && null == ((JDBCMemoryQueryResult)orderByValue.getQueryResult()).getCurrentRow();
    }

    private void addOrderedResultSetsToQueue(List<FetchOrderByValueGroup> fetchOrderByValueGroups, List<QueryResult> queryResults) {
        for (FetchOrderByValueGroup each : fetchOrderByValueGroups) {
            for (OrderByValue orderByValue : each.getOrderByValues()) {
                this.orderByValuesQueue.offer(orderByValue);
            }
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.isEmpty() ? queryResults.get(0) : this.orderByValuesQueue.peek().getQueryResult());
    }

    private QueryResult decorate(QueryResult queryResult, DatabaseType databaseType) throws SQLException {
        if (!DirectionType.isAllDirectionType((DirectionType)this.directionType) && queryResult instanceof JDBCStreamQueryResult) {
            return new JDBCMemoryQueryResult(((JDBCStreamQueryResult)queryResult).getResultSet(), databaseType);
        }
        return queryResult;
    }

    private void setMinResultSetRowCount(String cursorName, ConnectionContext connectionContext) {
        LinkedList<Long> rowCounts = new LinkedList<Long>();
        List fetchOrderByValueGroups = connectionContext.getCursorContext().getOrderByValueGroups().getOrDefault(cursorName, new LinkedList());
        for (FetchGroup each : fetchOrderByValueGroups) {
            rowCounts.add(this.getGroupRowCount((FetchOrderByValueGroup)each));
        }
        long minResultSetRowCount = DirectionType.isAllDirectionType((DirectionType)this.directionType) ? 0L : (Long)Collections.min(rowCounts) - this.fetchCount;
        connectionContext.getCursorContext().getMinGroupRowCounts().put(cursorName, Math.max(minResultSetRowCount, 0L));
    }

    private void handleExecutedAllDirections(ConnectionContext connectionContext, String cursorName) {
        if (connectionContext.getCursorContext().getExecutedAllDirections().containsKey(cursorName)) {
            this.isExecutedAllDirection = true;
        }
        if (DirectionType.isAllDirectionType((DirectionType)this.directionType)) {
            connectionContext.getCursorContext().getExecutedAllDirections().put(cursorName, true);
        }
    }

    private long getGroupRowCount(FetchOrderByValueGroup fetchOrderByValueGroup) {
        long result = 0L;
        for (OrderByValue each : fetchOrderByValueGroup.getOrderByValues()) {
            if (!(each.getQueryResult() instanceof JDBCMemoryQueryResult)) continue;
            JDBCMemoryQueryResult queryResult = (JDBCMemoryQueryResult)each.getQueryResult();
            result += null == queryResult.getCurrentRow() ? queryResult.getRowCount() : queryResult.getRowCount() + 1L;
        }
        return result;
    }
}

