/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.generic;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.exception.core.external.sql.vendor.VendorError;

public final class MySQLErrPacket
extends MySQLPacket {
    public static final int HEADER = 255;
    private static final String SQL_STATE_MARKER = "#";
    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    public MySQLErrPacket(SQLException exception) {
        this.errorCode = exception.getErrorCode();
        this.sqlState = exception.getSQLState();
        this.errorMessage = exception.getMessage();
    }

    public MySQLErrPacket(VendorError vendorError, Object ... errorMessageArgs) {
        this.errorCode = vendorError.getVendorCode();
        this.sqlState = vendorError.getSqlState().getValue();
        this.errorMessage = String.format(vendorError.getReason(), errorMessageArgs);
    }

    public MySQLErrPacket(MySQLPacketPayload payload) {
        Preconditions.checkArgument((255 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL ERR packet must be `0xff`.");
        this.errorCode = payload.readInt2();
        payload.readStringFix(1);
        this.sqlState = payload.readStringFix(5);
        this.errorMessage = payload.readStringEOF();
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        payload.writeInt1(255);
        payload.writeInt2(this.errorCode);
        payload.writeStringFix(SQL_STATE_MARKER);
        payload.writeStringFix(this.sqlState);
        payload.writeStringEOF(this.errorMessage);
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getSqlState() {
        return this.sqlState;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

