/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.spi;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.preconditions.AgentPreconditions;

public final class AgentServiceLoader<T> {
    private static final Map<Class<?>, AgentServiceLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Collection<T> services;

    private AgentServiceLoader(Class<T> service) {
        AgentPreconditions.checkArgument(service.isInterface(), String.format("SPI class `%s` is not interface.", service));
        this.services = this.load(service);
    }

    private Collection<T> load(Class<T> service) {
        LinkedList<T> result = new LinkedList<T>();
        for (T each : ServiceLoader.load(service)) {
            result.add(each);
        }
        return result;
    }

    public static <T> AgentServiceLoader<T> getServiceLoader(Class<T> service) {
        return LOADERS.computeIfAbsent(service, AgentServiceLoader::new);
    }

    @Generated
    public Collection<T> getServices() {
        return this.services;
    }
}

