/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansStatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.collector.trace.v1.internal.ExportTraceServiceRequest;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;

public final class LowAllocationTraceRequestMarshaler
extends Marshaler {
    private static final MarshalerContext.Key RESOURCE_SPAN_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key RESOURCE_SPAN_WRITER_KEY = MarshalerContext.key();
    private final MarshalerContext context = new MarshalerContext();
    private Map<Resource, Map<InstrumentationScopeInfo, List<SpanData>>> resourceAndScopeMap;
    private int size;

    public void initialize(Collection<SpanData> spanDataList) {
        this.resourceAndScopeMap = LowAllocationTraceRequestMarshaler.groupByResourceAndScope(this.context, spanDataList);
        this.size = LowAllocationTraceRequestMarshaler.calculateSize(this.context, this.resourceAndScopeMap);
    }

    public void reset() {
        this.context.reset();
    }

    @Override
    public int getBinarySerializedSize() {
        return this.size;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        this.context.resetReadIndex();
        output.serializeRepeatedMessageWithContext(ExportTraceServiceRequest.RESOURCE_SPANS, this.resourceAndScopeMap, ResourceSpansStatelessMarshaler.INSTANCE, this.context, RESOURCE_SPAN_WRITER_KEY);
    }

    private static int calculateSize(MarshalerContext context, Map<Resource, Map<InstrumentationScopeInfo, List<SpanData>>> resourceAndScopeMap) {
        return StatelessMarshalerUtil.sizeRepeatedMessageWithContext(ExportTraceServiceRequest.RESOURCE_SPANS, resourceAndScopeMap, ResourceSpansStatelessMarshaler.INSTANCE, context, RESOURCE_SPAN_SIZE_CALCULATOR_KEY);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<SpanData>>> groupByResourceAndScope(MarshalerContext context, Collection<SpanData> spanDataList) {
        if (spanDataList.isEmpty()) {
            return Collections.emptyMap();
        }
        return StatelessMarshalerUtil.groupByResourceAndScope(spanDataList, SpanData::getResource, SpanData::getInstrumentationScopeInfo, context);
    }
}

