/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.internal.ComponentLoader;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;

public final class AutoConfigureUtil {
    private AutoConfigureUtil() {
    }

    @Nullable
    public static ConfigProperties getConfig(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        try {
            Method method = AutoConfiguredOpenTelemetrySdk.class.getDeclaredMethod("getConfig", new Class[0]);
            method.setAccessible(true);
            return (ConfigProperties)method.invoke((Object)autoConfiguredOpenTelemetrySdk, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling getConfig on AutoConfiguredOpenTelemetrySdk", e);
        }
    }

    @Nullable
    public static StructuredConfigProperties getStructuredConfig(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        try {
            Method method = AutoConfiguredOpenTelemetrySdk.class.getDeclaredMethod("getStructuredConfig", new Class[0]);
            method.setAccessible(true);
            return (StructuredConfigProperties)method.invoke((Object)autoConfiguredOpenTelemetrySdk, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling getStructuredConfig on AutoConfiguredOpenTelemetrySdk", e);
        }
    }

    public static AutoConfiguredOpenTelemetrySdkBuilder setComponentLoader(AutoConfiguredOpenTelemetrySdkBuilder builder, ComponentLoader componentLoader) {
        try {
            Method method = AutoConfiguredOpenTelemetrySdkBuilder.class.getDeclaredMethod("setComponentLoader", ComponentLoader.class);
            method.setAccessible(true);
            method.invoke((Object)builder, componentLoader);
            return builder;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setComponentLoader on AutoConfiguredOpenTelemetrySdkBuilder", e);
        }
    }

    public static AutoConfiguredOpenTelemetrySdkBuilder setConfigPropertiesCustomizer(AutoConfiguredOpenTelemetrySdkBuilder builder, Function<ConfigProperties, ConfigProperties> customizer) {
        try {
            Method method = AutoConfiguredOpenTelemetrySdkBuilder.class.getDeclaredMethod("setConfigPropertiesCustomizer", Function.class);
            method.setAccessible(true);
            method.invoke((Object)builder, customizer);
            return builder;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setConfigPropertiesCustomizer on AutoConfiguredOpenTelemetrySdkBuilder", e);
        }
    }
}

