/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.MultiLogRecordExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.NoopLogRecordExporter;

public interface LogRecordExporter
extends Closeable {
    public static LogRecordExporter composite(LogRecordExporter ... exporters) {
        return LogRecordExporter.composite(Arrays.asList(exporters));
    }

    public static LogRecordExporter composite(Iterable<LogRecordExporter> exporters) {
        ArrayList<LogRecordExporter> exportersList = new ArrayList<LogRecordExporter>();
        for (LogRecordExporter exporter : exporters) {
            exportersList.add(exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopLogRecordExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (LogRecordExporter)exportersList.get(0);
        }
        return MultiLogRecordExporter.create(exportersList);
    }

    public CompletableResultCode export(Collection<LogRecordData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

