/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.metadata.processor;

import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.config.processor.JobConfigurationChangedProcessor;
import org.apache.shardingsphere.data.pipeline.core.preparer.incremental.IncrementalTaskPositionManager;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJob;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.swapper.YamlMigrationJobConfigurationSwapper;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobConfigurationChangedProcessor
implements JobConfigurationChangedProcessor<MigrationJobConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobConfigurationChangedProcessor.class);

    public PipelineJob createJob(MigrationJobConfiguration jobConfig) {
        return new MigrationJob();
    }

    public void clean(JobConfiguration jobConfig) {
        MigrationJobConfiguration migrationJobConfig = new YamlMigrationJobConfigurationSwapper().swapToObject(jobConfig.getJobParameter());
        for (Map.Entry<String, PipelineDataSourceConfiguration> entry : migrationJobConfig.getSources().entrySet()) {
            try {
                new IncrementalTaskPositionManager(entry.getValue().getDatabaseType()).destroyPosition(migrationJobConfig.getJobId(), entry.getValue());
            }
            catch (SQLException ex) {
                log.warn("Job destroying failed, jobId={}, dataSourceName={}", new Object[]{migrationJobConfig.getJobId(), entry.getKey(), ex});
            }
        }
    }

    public String getType() {
        return "MIGRATION";
    }
}

