/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.column.PostgreSQLColumnPropertiesAppender;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.constraints.PostgreSQLConstraintsPropertiesAppender;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.index.PostgreSQLIndexSQLGenerator;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.table.PostgreSQLTablePropertiesLoader;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.template.PostgreSQLPipelineFreemarkerManager;

public final class PostgreSQLPipelineSQLBuilder
implements DialectPipelineSQLBuilder {
    public Optional<String> buildCreateSchemaSQL(String schemaName) {
        return Optional.of(String.format("CREATE SCHEMA IF NOT EXISTS %s", schemaName));
    }

    public Optional<String> buildInsertOnDuplicateClause(DataRecord dataRecord) {
        if (dataRecord.getUniqueKeyValue().isEmpty()) {
            return Optional.empty();
        }
        StringBuilder result = new StringBuilder("ON CONFLICT (");
        PipelineSQLSegmentBuilder sqlSegmentBuilder = new PipelineSQLSegmentBuilder(this.getType());
        result.append(dataRecord.getColumns().stream().filter(Column::isUniqueKey).map(each -> sqlSegmentBuilder.getEscapedIdentifier(each.getName())).collect(Collectors.joining(",")));
        result.append(") DO UPDATE SET ");
        result.append(dataRecord.getColumns().stream().filter(each -> !each.isUniqueKey()).map(each -> sqlSegmentBuilder.getEscapedIdentifier(each.getName()) + "=EXCLUDED." + sqlSegmentBuilder.getEscapedIdentifier(each.getName())).collect(Collectors.joining(",")));
        return Optional.of(result.toString());
    }

    public String buildCheckEmptyTableSQL(String qualifiedTableName) {
        return String.format("SELECT * FROM %s LIMIT 1", qualifiedTableName);
    }

    public Optional<String> buildEstimatedCountSQL(String catalogName, String qualifiedTableName) {
        return Optional.of(String.format("SELECT reltuples::integer FROM pg_class WHERE oid='%s'::regclass::oid;", qualifiedTableName));
    }

    public Optional<String> buildCRC32SQL(String qualifiedTableName, String columnName) {
        return Optional.of(String.format("SELECT pg_catalog.pg_checksum_table('%s', true)", qualifiedTableName));
    }

    public Collection<String> buildCreateTableSQLs(DataSource dataSource, String schemaName, String tableName) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            int majorVersion = connection.getMetaData().getDatabaseMajorVersion();
            int minorVersion = connection.getMetaData().getDatabaseMinorVersion();
            Map<String, Object> materials = this.loadMaterials(tableName, schemaName, connection, majorVersion, minorVersion);
            String tableSQL = this.generateCreateTableSQL(majorVersion, minorVersion, materials);
            String indexSQL = this.generateCreateIndexSQL(connection, majorVersion, minorVersion, materials);
            List<String> list = Arrays.asList((tableSQL + System.lineSeparator() + indexSQL).trim().split(";"));
            return list;
        }
    }

    private Map<String, Object> loadMaterials(String tableName, String schemaName, Connection connection, int majorVersion, int minorVersion) throws SQLException {
        Map<String, Object> result = new PostgreSQLTablePropertiesLoader(connection, tableName, schemaName, majorVersion, minorVersion).load();
        new PostgreSQLColumnPropertiesAppender(connection, majorVersion, minorVersion).append(result);
        new PostgreSQLConstraintsPropertiesAppender(connection, majorVersion, minorVersion).append(result);
        this.formatColumns(result);
        return result;
    }

    private String generateCreateTableSQL(int majorVersion, int minorVersion, Map<String, Object> materials) {
        return PostgreSQLPipelineFreemarkerManager.getSQLByVersion(materials, "component/table/%s/create.ftl", majorVersion, minorVersion).trim();
    }

    private String generateCreateIndexSQL(Connection connection, int majorVersion, int minorVersion, Map<String, Object> materials) throws SQLException {
        return new PostgreSQLIndexSQLGenerator(connection, majorVersion, minorVersion).generate(materials);
    }

    private void formatColumns(Map<String, Object> context) {
        Collection columns = (Collection)context.get("columns");
        for (Map each : columns) {
            if (!each.containsKey("cltype")) continue;
            this.typeFormatter(each, (String)each.get("cltype"));
        }
    }

    private void typeFormatter(Map<String, Object> column, String columnType) {
        if (columnType.contains("[]")) {
            column.put("cltype", columnType.substring(0, columnType.length() - 2));
            column.put("hasSqrBracket", true);
        } else {
            column.put("hasSqrBracket", false);
        }
    }

    public Optional<String> buildQueryCurrentPositionSQL() {
        return Optional.of("SELECT * FROM pg_current_wal_lsn()");
    }

    public String wrapWithPageQuery(String sql) {
        return sql + " LIMIT ?";
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

