/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datasource.config;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class PipelineDataSourceConfigurationFactory {
    public static PipelineDataSourceConfiguration newInstance(String type, String param) {
        switch (type) {
            case "JDBC": {
                return new StandardPipelineDataSourceConfiguration(param);
            }
            case "ShardingSphereJDBC": {
                return new ShardingSpherePipelineDataSourceConfiguration(param);
            }
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported data source type `%s`", type));
    }

    @Generated
    private PipelineDataSourceConfigurationFactory() {
    }
}

