/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.importer;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.importer.Importer;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;

public final class SingleChannelConsumerImporter
extends AbstractPipelineLifecycleRunnable
implements Importer {
    private final PipelineChannel channel;
    private final int batchSize;
    private final long timeoutMillis;
    private final PipelineSink sink;
    private final PipelineJobProgressListener jobProgressListener;

    @Override
    protected void runBlocking() {
        while (this.isRunning()) {
            List<Record> records = this.channel.fetch(this.batchSize, this.timeoutMillis);
            if (records.isEmpty()) continue;
            PipelineJobUpdateProgress updateProgress = this.sink.write("", records);
            this.channel.ack(records);
            this.jobProgressListener.onProgressUpdated(updateProgress);
            if (!FinishedRecord.class.equals(records.get(records.size() - 1).getClass())) continue;
            break;
        }
    }

    @Override
    protected void doStop() {
        QuietlyCloser.close((AutoCloseable)this.sink);
    }

    @Generated
    public SingleChannelConsumerImporter(PipelineChannel channel, int batchSize, long timeoutMillis, PipelineSink sink, PipelineJobProgressListener jobProgressListener) {
        this.channel = channel;
        this.batchSize = batchSize;
        this.timeoutMillis = timeoutMillis;
        this.sink = sink;
        this.jobProgressListener = jobProgressListener;
    }
}

