/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.DumperCommonContext;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;

public final class InventoryDumperContext {
    private final DumperCommonContext commonContext;
    private String actualTableName;
    private String logicTableName;
    private List<PipelineColumnMetaData> uniqueKeyColumns;
    private List<String> insertColumnNames;
    private String querySQL;
    private List<Object> queryParams;
    private Integer transactionIsolation;
    private int shardingItem;
    private int batchSize = 1000;
    private JobRateLimitAlgorithm rateLimitAlgorithm;
    private boolean firstDump = true;

    public InventoryDumperContext(DumperCommonContext commonContext) {
        this.commonContext = new DumperCommonContext(commonContext.getDataSourceName(), commonContext.getDataSourceConfig(), commonContext.getTableNameMapper(), commonContext.getTableAndSchemaNameMapper());
    }

    public boolean hasUniqueKey() {
        return null != this.uniqueKeyColumns && !this.uniqueKeyColumns.isEmpty();
    }

    public List<String> getQueryColumnNames() {
        return Optional.ofNullable(this.insertColumnNames).orElse(Collections.singletonList("*"));
    }

    @Generated
    public DumperCommonContext getCommonContext() {
        return this.commonContext;
    }

    @Generated
    public String getActualTableName() {
        return this.actualTableName;
    }

    @Generated
    public String getLogicTableName() {
        return this.logicTableName;
    }

    @Generated
    public List<PipelineColumnMetaData> getUniqueKeyColumns() {
        return this.uniqueKeyColumns;
    }

    @Generated
    public List<String> getInsertColumnNames() {
        return this.insertColumnNames;
    }

    @Generated
    public String getQuerySQL() {
        return this.querySQL;
    }

    @Generated
    public List<Object> getQueryParams() {
        return this.queryParams;
    }

    @Generated
    public Integer getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public JobRateLimitAlgorithm getRateLimitAlgorithm() {
        return this.rateLimitAlgorithm;
    }

    @Generated
    public boolean isFirstDump() {
        return this.firstDump;
    }

    @Generated
    public void setActualTableName(String actualTableName) {
        this.actualTableName = actualTableName;
    }

    @Generated
    public void setLogicTableName(String logicTableName) {
        this.logicTableName = logicTableName;
    }

    @Generated
    public void setUniqueKeyColumns(List<PipelineColumnMetaData> uniqueKeyColumns) {
        this.uniqueKeyColumns = uniqueKeyColumns;
    }

    @Generated
    public void setInsertColumnNames(List<String> insertColumnNames) {
        this.insertColumnNames = insertColumnNames;
    }

    @Generated
    public void setQuerySQL(String querySQL) {
        this.querySQL = querySQL;
    }

    @Generated
    public void setQueryParams(List<Object> queryParams) {
        this.queryParams = queryParams;
    }

    @Generated
    public void setTransactionIsolation(Integer transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    @Generated
    public void setShardingItem(int shardingItem) {
        this.shardingItem = shardingItem;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setRateLimitAlgorithm(JobRateLimitAlgorithm rateLimitAlgorithm) {
        this.rateLimitAlgorithm = rateLimitAlgorithm;
    }

    @Generated
    public void setFirstDump(boolean firstDump) {
        this.firstDump = firstDump;
    }

    @Generated
    public String toString() {
        return "InventoryDumperContext(commonContext=" + this.getCommonContext() + ", actualTableName=" + this.getActualTableName() + ", logicTableName=" + this.getLogicTableName() + ", uniqueKeyColumns=" + this.getUniqueKeyColumns() + ", insertColumnNames=" + this.getInsertColumnNames() + ", querySQL=" + this.getQuerySQL() + ", queryParams=" + this.getQueryParams() + ", transactionIsolation=" + this.getTransactionIsolation() + ", shardingItem=" + this.getShardingItem() + ", batchSize=" + this.getBatchSize() + ", rateLimitAlgorithm=" + this.getRateLimitAlgorithm() + ", firstDump=" + this.isFirstDump() + ")";
    }
}

