/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobProgressDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobProgressDetector.class);

    public static boolean isAllInventoryTasksFinished(Collection<PipelineTask> inventoryTasks) {
        if (inventoryTasks.isEmpty()) {
            log.warn("inventoryTasks is empty");
        }
        return inventoryTasks.stream().allMatch(each -> each.getTaskProgress().getPosition() instanceof IngestFinishedPosition);
    }

    public static boolean isInventoryFinished(int jobShardingCount, Collection<TransmissionJobItemProgress> jobItemProgresses) {
        return PipelineJobProgressDetector.isAllProgressesFilled(jobShardingCount, jobItemProgresses) && PipelineJobProgressDetector.isAllInventoryTasksCompleted(jobItemProgresses);
    }

    private static boolean isAllProgressesFilled(int jobShardingCount, Collection<TransmissionJobItemProgress> jobItemProgresses) {
        return jobShardingCount == jobItemProgresses.size() && jobItemProgresses.stream().allMatch(Objects::nonNull);
    }

    private static boolean isAllInventoryTasksCompleted(Collection<TransmissionJobItemProgress> jobItemProgresses) {
        if (jobItemProgresses.stream().allMatch(each -> each.getInventory().getProgresses().isEmpty())) {
            return false;
        }
        return jobItemProgresses.stream().flatMap(each -> each.getInventory().getProgresses().values().stream()).allMatch(each -> each.getPosition() instanceof IngestFinishedPosition);
    }

    @Generated
    private PipelineJobProgressDetector() {
    }
}

