/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress;

import java.util.Collection;
import java.util.HashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemInventoryTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.core.task.progress.InventoryTaskProgress;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class TransmissionJobItemProgress
implements PipelineJobItemProgress {
    private DatabaseType sourceDatabaseType;
    private String dataSourceName;
    private JobItemInventoryTasksProgress inventory;
    private JobItemIncrementalTasksProgress incremental;
    private long inventoryRecordsCount;
    private long processedRecordsCount;
    private boolean active;
    private JobStatus status = JobStatus.RUNNING;

    public TransmissionJobItemProgress(TransmissionJobItemContext context) {
        this.sourceDatabaseType = context.getJobConfig().getSourceDatabaseType();
        this.dataSourceName = context.getDataSourceName();
        this.inventory = this.getInventoryTasksProgress(context.getInventoryTasks());
        this.incremental = this.getIncrementalTasksProgress(context.getIncrementalTasks());
        this.inventoryRecordsCount = context.getInventoryRecordsCount();
        this.processedRecordsCount = context.getProcessedRecordsCount();
        this.status = context.getStatus();
    }

    private JobItemIncrementalTasksProgress getIncrementalTasksProgress(Collection<PipelineTask> incrementalTasks) {
        return new JobItemIncrementalTasksProgress(incrementalTasks.isEmpty() ? null : (IncrementalTaskProgress)incrementalTasks.iterator().next().getTaskProgress());
    }

    private JobItemInventoryTasksProgress getInventoryTasksProgress(Collection<PipelineTask> inventoryTasks) {
        HashMap<String, InventoryTaskProgress> inventoryTaskProgressMap = new HashMap<String, InventoryTaskProgress>(inventoryTasks.size(), 1.0f);
        for (PipelineTask each : inventoryTasks) {
            inventoryTaskProgressMap.put(each.getTaskId(), (InventoryTaskProgress)each.getTaskProgress());
        }
        return new JobItemInventoryTasksProgress(inventoryTaskProgressMap);
    }

    @Generated
    public TransmissionJobItemProgress() {
    }

    @Generated
    public DatabaseType getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public JobItemInventoryTasksProgress getInventory() {
        return this.inventory;
    }

    @Generated
    public JobItemIncrementalTasksProgress getIncremental() {
        return this.incremental;
    }

    @Generated
    public long getInventoryRecordsCount() {
        return this.inventoryRecordsCount;
    }

    @Generated
    public long getProcessedRecordsCount() {
        return this.processedRecordsCount;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Override
    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setSourceDatabaseType(DatabaseType sourceDatabaseType) {
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Generated
    public void setInventory(JobItemInventoryTasksProgress inventory) {
        this.inventory = inventory;
    }

    @Generated
    public void setIncremental(JobItemIncrementalTasksProgress incremental) {
        this.incremental = incremental;
    }

    @Generated
    public void setInventoryRecordsCount(long inventoryRecordsCount) {
        this.inventoryRecordsCount = inventoryRecordsCount;
    }

    @Generated
    public void setProcessedRecordsCount(long processedRecordsCount) {
        this.processedRecordsCount = processedRecordsCount;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }
}

