/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.MySQLInformationSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.MySQLMySQLSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.MySQLPerformanceSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.MySQLSysSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.KillProcessExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.MySQLSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.MySQLSystemVariableQueryExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.NoResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowConnectionIdExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowCreateDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowCurrentDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowCurrentUserExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowDatabasesExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowFunctionStatusExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowProcedureStatusExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowProcessListExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowTablesExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.ShowVersionExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.UnicastResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.UseDatabaseExecutor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.KillStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowTablesStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class MySQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String MYSQL_SCHEMA = "mysql";
    private static final String PERFORMANCE_SCHEMA = "performance_schema";
    private static final String SYS_SCHEMA = "sys";

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext) {
        return Optional.empty();
    }

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SelectStatement) {
            return this.create((SelectStatement)sqlStatement, sql, databaseName, parameters);
        }
        if (sqlStatement instanceof UseStatement) {
            return Optional.of(new UseDatabaseExecutor((UseStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowDatabasesStatement) {
            return Optional.of(new ShowDatabasesExecutor((ShowDatabasesStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowTablesStatement) {
            return Optional.of(new ShowTablesExecutor((ShowTablesStatement)sqlStatement, sqlStatementContext.getDatabaseType()));
        }
        if (sqlStatement instanceof ShowCreateDatabaseStatement) {
            return Optional.of(new ShowCreateDatabaseExecutor((ShowCreateDatabaseStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowFunctionStatusStatement) {
            return Optional.of(new ShowFunctionStatusExecutor((ShowFunctionStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowProcedureStatusStatement) {
            return Optional.of(new ShowProcedureStatusExecutor((ShowProcedureStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new MySQLSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowProcessListStatement) {
            return Optional.of(new ShowProcessListExecutor(((ShowProcessListStatement)sqlStatement).isFull()));
        }
        if (sqlStatement instanceof KillStatement) {
            return Optional.of(new KillProcessExecutor((KillStatement)sqlStatement));
        }
        return Optional.empty();
    }

    private Optional<DatabaseAdminExecutor> create(SelectStatement selectStatement, String sql, String databaseName, List<Object> parameters) {
        if (!selectStatement.getFrom().isPresent()) {
            return this.findAdminExecutorForSelectWithoutFrom(sql, databaseName, selectStatement);
        }
        if (this.isQueryInformationSchema(databaseName)) {
            return MySQLInformationSchemaExecutorFactory.newInstance(selectStatement, sql, parameters);
        }
        if (this.isQueryPerformanceSchema(databaseName)) {
            return MySQLPerformanceSchemaExecutorFactory.newInstance(selectStatement, sql, parameters);
        }
        if (this.isQueryMySQLSchema(databaseName)) {
            return MySQLMySQLSchemaExecutorFactory.newInstance(selectStatement, sql, parameters);
        }
        if (this.isQuerySysSchema(databaseName)) {
            return MySQLSysSchemaExecutorFactory.newInstance(selectStatement, sql, parameters);
        }
        return Optional.empty();
    }

    private Optional<DatabaseAdminExecutor> findAdminExecutorForSelectWithoutFrom(String sql, String databaseName, SelectStatement selectStatement) {
        Optional<DatabaseAdminExecutor> result = MySQLSystemVariableQueryExecutor.tryGetSystemVariableQueryExecutor(selectStatement);
        return result.isPresent() ? result : this.getSelectFunctionOrVariableExecutor(selectStatement, sql, databaseName);
    }

    private Optional<DatabaseAdminExecutor> getSelectFunctionOrVariableExecutor(SelectStatement selectStatement, String sql, String databaseName) {
        if (this.isShowSpecialFunction(selectStatement, "connection_id()")) {
            return Optional.of(new ShowConnectionIdExecutor(selectStatement));
        }
        if (this.isShowSpecialFunction(selectStatement, "version()")) {
            return Optional.of(new ShowVersionExecutor(selectStatement));
        }
        if (this.isShowSpecialFunction(selectStatement, "current_user()") || this.isShowSpecialFunction(selectStatement, "current_user")) {
            return Optional.of(new ShowCurrentUserExecutor());
        }
        if (this.isShowSpecialFunction(selectStatement, "DATABASE()")) {
            return Optional.of(new ShowCurrentDatabaseExecutor());
        }
        return this.mockExecutor(databaseName, selectStatement, sql);
    }

    private boolean isShowSpecialFunction(SelectStatement sqlStatement, String functionName) {
        Iterator segmentIterator = sqlStatement.getProjections().getProjections().iterator();
        ProjectionSegment firstProjection = (ProjectionSegment)segmentIterator.next();
        return !segmentIterator.hasNext() && firstProjection instanceof ExpressionProjectionSegment && functionName.equalsIgnoreCase(((ExpressionProjectionSegment)firstProjection).getText());
    }

    private boolean isQueryInformationSchema(String databaseName) {
        return INFORMATION_SCHEMA.equalsIgnoreCase(databaseName) && !ProxyContext.getInstance().getContextManager().getDatabase(databaseName).isComplete();
    }

    private boolean isQueryPerformanceSchema(String databaseName) {
        return PERFORMANCE_SCHEMA.equalsIgnoreCase(databaseName);
    }

    private boolean isQueryMySQLSchema(String databaseName) {
        return MYSQL_SCHEMA.equalsIgnoreCase(databaseName);
    }

    private boolean isQuerySysSchema(String databaseName) {
        return SYS_SCHEMA.equalsIgnoreCase(databaseName);
    }

    private Optional<DatabaseAdminExecutor> mockExecutor(String databaseName, SelectStatement sqlStatement, String sql) {
        if (this.hasNoResource()) {
            return Optional.of(new NoResourceShowExecutor(sqlStatement));
        }
        boolean isNotUseSchema = null == databaseName && !sqlStatement.getFrom().isPresent();
        return isNotUseSchema ? Optional.of(new UnicastResourceShowExecutor(sqlStatement, sql)) : Optional.empty();
    }

    private boolean hasNoResource() {
        Collection databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            return true;
        }
        for (String each : databaseNames) {
            if (!ProxyContext.getInstance().getContextManager().getDatabase(each).containsDataSource()) continue;
            return false;
        }
        return true;
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

