/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;

public final class StorageUnitNodeMapCreator {
    public static Map<String, StorageNode> create(Map<String, DataSourcePoolProperties> propsMap) {
        return propsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StorageUnitNodeMapCreator.create((String)entry.getKey(), (DataSourcePoolProperties)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static StorageNode create(String storageUnitName, DataSourcePoolProperties props) {
        Map standardProps = props.getConnectionPropertySynonyms().getStandardProperties();
        return StorageUnitNodeMapCreator.create(storageUnitName, standardProps.get("url").toString(), standardProps.get("username").toString());
    }

    private static StorageNode create(String storageUnitName, String url, String username) {
        boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(DatabaseTypeFactory.get((String)url)).getDialectDatabaseMetaData().isInstanceConnectionAvailable();
        try {
            ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)DatabaseTypeFactory.get((String)url))).parse(url, username, null);
            return isInstanceConnectionAvailable ? new StorageNode(connectionProps.getHostname(), connectionProps.getPort(), username) : new StorageNode(storageUnitName);
        }
        catch (UnrecognizedDatabaseURLException ex) {
            return new StorageNode(storageUnitName);
        }
    }

    @Generated
    private StorageUnitNodeMapCreator() {
    }
}

