/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.user;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import lombok.Generated;

public final class Grantee {
    private static final String DELIMITER = "@";
    private static final String HOST_WILDCARD = "%";
    private final String username;
    private final String hostname;
    private final boolean isUnlimitedHost;
    private final int hashCode;
    private final String toString;

    public Grantee(String value) {
        this(value.contains(DELIMITER) ? value.substring(0, value.indexOf(64)) : value, value.contains(DELIMITER) ? value.substring(value.indexOf(64) + 1) : "");
    }

    public Grantee(String username, String hostname) {
        this.username = username;
        this.hostname = Strings.isNullOrEmpty((String)hostname) ? HOST_WILDCARD : hostname;
        this.isUnlimitedHost = HOST_WILDCARD.equals(this.hostname);
        this.hashCode = Objects.hashCode((Object[])new Object[]{username.toUpperCase(), this.hostname.toUpperCase()});
        this.toString = username + DELIMITER + this.hostname;
    }

    public boolean accept(Grantee grantee) {
        return grantee.username.equalsIgnoreCase(this.username) && this.isPermittedHost(grantee);
    }

    private boolean isPermittedHost(Grantee grantee) {
        return this.isUnlimitedHost || grantee.hostname.equalsIgnoreCase(this.hostname);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Grantee) {
            Grantee grantee = (Grantee)obj;
            return grantee.username.equalsIgnoreCase(this.username) && grantee.hostname.equalsIgnoreCase(this.hostname);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }
}

