/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.listener;

import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.ConnectionStateChangedEventListener;

public final class RegistryCenterConnectionStateListener
implements ConnectionStateChangedEventListener {
    private final String jobName;
    private final ServerService serverService;
    private final InstanceService instanceService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;

    public RegistryCenterConnectionStateListener(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.serverService = new ServerService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
    }

    public void onStateChanged(CoordinatorRegistryCenter registryCenter, ConnectionStateChangedEventListener.State newState) {
        if (JobRegistry.getInstance().isShutdown(this.jobName)) {
            return;
        }
        JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(this.jobName);
        if (ConnectionStateChangedEventListener.State.UNAVAILABLE == newState) {
            jobScheduleController.pauseJob();
        } else if (ConnectionStateChangedEventListener.State.RECONNECTED == newState) {
            this.serverService.persistOnline(this.serverService.isEnableServer(JobRegistry.getInstance().getJobInstance(this.jobName).getServerIp()));
            this.instanceService.persistOnline();
            this.executionService.clearRunningInfo(this.shardingService.getLocalShardingItems());
            jobScheduleController.resumeJob();
        }
    }
}

